﻿using System;
using System.Linq;

namespace SparkCruise
{
    public partial class User
    {
        public byte ConnectionId
        {
            get;
            set;
        }

        public bool IsAdmin
        {
            get;
            set;
        }

        public int Speed
        {
            get;
            set;
        }

        public int LastX
        {
            get;
            set;
        }

        public int LastY
        {
            get;
            set;
        }

        public int LastZ
        {
            get;
            set;
        }

        public string CurrentCar 
        { 
            get;
            set;
        }

        public bool IsHost
        {
            get
            {
                return ConnectionId == 0;
            }
        }

        public Car FindCar(string car)
        {
            return Cars.SingleOrDefault(c => c.Name == car);
        }

        public bool TryGetCar(string car, out Car item)
        {
            item = FindCar(car);
            return item != null;
        }

        public bool HasCar(string car)
        {
            return Cars.Any(c => c.Name == car);
        }
    }
}
