/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Collections;
using System.Text;
using System.IO;

namespace LFSLapper
{
    class userGroups
    {
        private GLDebug.Debug myDebug;
        Hashtable listOfGroups = new Hashtable();
        public userGroups(GLDebug.Debug pmyDebug)
        {
            this.myDebug = pmyDebug;
        }
        public void addUserFromFile(string group, string filepath)
        {
            StreamReader sr;

            if (!listOfGroups.Contains(group))
            {
                listOfGroups[group] = new Hashtable();
            }
            Hashtable currGroup = (Hashtable)listOfGroups[group];
            currGroup.Clear();
            try
            {
                using (sr = new System.IO.StreamReader(filepath))
                {
                    while (true)
                    {
                        if (sr.EndOfStream)
                            break;
                        string user = sr.ReadLine().Trim().ToLower();
                        string[] users = user.Split(',');
                        for (int i = 0; i < users.Length; i++)
                            currGroup[users[i]] = true;
                    }
                }
            }
            catch{
                myDebug.WriteLine("err","Can't open group file : " + filepath);
            }
        }
        public void addUser(string group, string user)
        {
            if (!listOfGroups.Contains(group))
            {
                listOfGroups[group] = new Hashtable();
            }
            Hashtable currGroup = (Hashtable)listOfGroups[group];
            string[] users = user.ToLower().Split(',');
            for (int i = 0; i < users.Length; i++)
                currGroup[users[i]] = true;
        }
        public void removeUser(string group, string user)
        {
            if (listOfGroups.Contains(group))
            {
                Hashtable currGroup = (Hashtable)listOfGroups[group];
                string[] users = user.ToLower().Split(',');
                for (int i = 0; i < users.Length; i++)
                    currGroup.Remove(users[i]);
            }
        }
        public void clear(string group)
        {
            if (listOfGroups.Contains(group))
            {
                Hashtable currGroup = (Hashtable)listOfGroups[group];
                currGroup.Clear();
            }
        }
        public bool userExist(string group, string user)
        {
            if (listOfGroups.Contains(group))
            {
                Hashtable currGroup = (Hashtable)listOfGroups[group];
                string[] users = user.ToLower().Split(',');
                for (int i = 0; i < users.Length; i++)
                {
                    if (currGroup.Contains(users[i]))
                        return true;
                }
            }
            return false;
        }
    }
}
