 /*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty ofatabase
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.IO;
using System.Text;
using System.Collections;
using System.Reflection;
using GLScript;
namespace Configurator
{


    public enum typFunction
    {
        Event,
        Sub,
    }
    public enum typVar
    {
        str,
        num,
        ip,
    }
    enum eventAllowed{
        OnMSO,
        OnLapperStart,
        OnAuthAllowed,
        OnAuthNotAllowed,
        OnAuthReached,
        OnSwearWords1,
        OnSwearWords2,
        OnToLowHandicap,
        OnNotMatchFlags,
        OnVoteRestartChange,
        OnVoteRestartReach,
        OnVoteRestartZero,
        OnVoteQualifyChange,
        OnVoteQualifyReach,
        OnVoteQualifyZero,
        OnVoteEndChange,
        OnVoteEndReach,
        OnVoteEndZero,
        OnConnect,
        OnDisConnect,
        OnSplit1,
        OnSplit2,
        OnSplit3,
        OnLap,
        OnSpbSplit1,
        OnSpbSplit2,
        OnSpbSplit3,
        OnSpbLast,
        OnFlood,
        OnRaceStart,
        OnMaxSessionLaps,
        OnAngleVelocity,
        OnMaxNbInStunt,
        OnMaxAllowedLapTime1,
        OnMaxAllowedLapTime2,
        OnIdle1,
        OnIdle2,
        OnDriftPB,
        OnDriftLap,
        OnDriftScore,
        OnPB,
        OnPBQual,
        OnAcceleration,
        OnEnterPit,
        OnBeginPit,
        OnEndPit,
        OnPit,
        OnNotPitWindow,
        OnBeginPitWindow,
        OnEndPitWindow,
        OnFastDriveOnPitL1,
        OnFastDriveOnPitL2,
        OnMaxFastDriveOnPit,
        OnFalseStartL1,
        OnFalseStartL2,
        OnLeaveRace,
        OnDriftTooLow,
        OnGoodDrift,
        OnRotateCar,
        OnRotateTrack,
        OnNewGapPlayerBehind,
        OnNewGapPlayerBefore,
        OnQualStart,
        OnNewPlayerJoin,
        OnChangeTyres,
        OnFinish,
        OnResult,
        OnCarReset,
        OnMaxCarResets,

    }
    public class VLAPPER
    {
        public string Password;
        public string WorkingDir;
        public string superUsers;
        public string StoredValueDbs;
        public string TrackInfoFile;
        public bool TCPmode = true;
        public bool EnableRegisterWeb = true;
        public string DateFormat = "dd/MM/yyyy";
        public string LongDateFormat = "dd m yyyy";
        public string adminEmail = "";
        public string smtpServer = "";
        public string loginMail = "";
        public string passMail = "";

        public int MessageTime = 5000;
        public bool ShowPlayerControl = true;
        public string FtpServer = "";
        public string FtpLogin = "";
        public string FtpPasswd = "";
        public string FtpRemotePath = "";
//        public string SyncID = "";
//        public string SyncDir = "";
//       public string SyncIDsToSync = "";
        public string DefaultTopCar;
        public string PubStatIdk = "";
        // AUthorization
        public string Auth1 = "";
        public string Auth2 = "";
        public string Auth3 = "";
        public string Auth4 = "";
        public string Auth5 = "";
        public string Auth6 = "";
        public string Auth7 = "";
        public string Auth8 = "";
        public string Auth9 = "";
        public string Auth10 = "";
        public string AuthAllowPlayer = "All";
        public int AuthMinPlayer = 0;
        //SwearWordsList
        public string SwearWordsList = "";
        public int SwearWordsMax = 2;
        // HandicapCars
        public string HandicapCars = "";
        public string HandicapCarsTracks = "";
        public bool RefreshHandicapUsers = false;
        public string HandicapUsers = "";
        // Control Allowed 
        public string SwapSide = "*";
        public string AutoGears = "*";
        public string Shifter = "*";
        public string HelpBrake = "*";
        public string AxisClutch = "*";
        public string AutoClutch = "*";
        public string Mouse = "*";
        public string KbNoHelp = "*";
        public string KbStabilised = "*";
        public string CustomView = "*";
        // Votation
        public string InRaceLapsVoteMinMax = "0-9999999";
        public int VoteLifeSec = 30;

        public int VoteRestart = -1;
        public int VoteQualify = -1;
        public int VoteEnd = -1;
        // Rotation
        public int AutoRestartRaceSec = 0;
        public int RotateEveryNbRaces = 4;
        public bool EnableRotation = false;
        public string RotateTracks = "";
        public string RotateCars = "";
        // Connection
        // Splitting
        public bool ShowSplitPB = true;
        // List of user qualifying 
        public bool RefreshQualUsers = true;
        public string QualUsers = "";
        // Flood Actions
        public int MaxFloodLines = 4;
        public int MaxFloodLinesTime = 5000;
        // Session action
        public int MaxSessionLaps = 99999;
        //Spinning detection options
        public int MinAngleVelocity = 250;
        public int MaxNbInStunt = 32768;
        // to Slow user
        public int MaxAllowedLapTime1 = -1;

        public int MaxAllowedLapTime2 = -1;
        // Idling options
        public int OnIdleTimeout1 = 60;
        public string IdleExclude = "";

        public int OnIdleTimeout2 = 120;
        // Drifting
        public string DriftDatabase = "./PBdrift";
        public int GoodDriftScore = 4000;
        public int MinimumDriftScore = 10;
        public int MinimumDriftSpeed = 50;
        public int MinimumDriftAngle = 15;
        public int MaximumDriftAngle = 100;
        // Hotlapping options
        public string GripDatabase = "./PBgrip";
        public int LapTimeUsedForPb = 1;
        // Acceleration options
        public double AccelerationStartSpeed = 1;
        public double AccelerationEndSpeed = 100;
        public double AccelerationStartSpeedMph = 1;
        public double AccelerationEndSpeedMph = 60;
        public double AccelerationPrivateMaxTime = 10;
        // Penalties
        public int MaxFastDriveOnPit = 99999;

        // Pit windows
        public int PitWindowStart = 0;
        public int PitWindowStop = 0;

        // Car Resets
        public int MaxCarResets = 0;



    }

    public class lexConfigurator
    {
        public VLAPPER varsLapper;
        private GLScript.GLApp CurrApp;
        private LFSLapper.lang lfsLang;
        public System.Collections.ArrayList Tasks = new System.Collections.ArrayList();
        LFSLapper.infoPlayer currInfoPlayer;
        private GLDebug.Debug myDebug;

        public lexConfigurator( GLDebug.Debug pmyDebug, LFSLapper.lang plfsLang, GLApp.callBackFunctions FBC )
        {
           
            varsLapper = new VLAPPER();
            myDebug = pmyDebug;

            CurrApp = new GLApp(myDebug, "", FBC);
            lfsLang = plfsLang;

        }
        public void setLocalVar(string idVar, string value )
        {
            // TODO
        }
        public void executeFunction(string funcName, LFSLapper.infoPlayer pcurrInfoPlayer, string[] par )
        {
            currInfoPlayer = pcurrInfoPlayer;
            if (currInfoPlayer != null && currInfoPlayer.functionsLapper.Contains(funcName))
            {
                GLApp.functionDef myFuncDef = (GLApp.functionDef)currInfoPlayer.functionsLapper[funcName];
                CurrApp.registerFunction(funcName, myFuncDef);
            }
            CurrApp.executeFunction(funcName, par);
        }
        public LFSLapper.infoPlayer getCurrInfoPlayer()
        {
            return currInfoPlayer;
        }
        public void addFunction(string id, string buff, string args )
        {
            CurrApp.registerFunction(id, buff, args,"", 1);
        }
        public void dumpNamesFunctions()
        {
            CurrApp.dumpNamesFunctions();
        }
        public bool load(string filepath )
        {
            StringBuilder strSrc = new StringBuilder();
            string myPath = Path.GetDirectoryName(filepath);
            if (myPath == "")
                myPath = ".";
            load2(myPath, Path.GetFileName( filepath ), strSrc);
            tokenize( strSrc.ToString());
            return true;
        }
        private bool load2(string path, string filepath, StringBuilder strSrc)
        {
            string openFile = path + "/" + filepath;
            int currLine = 0;
            StreamReader sr = null;

            try
            {
                sr = new StreamReader(openFile);
            }
            catch
            {
                myDebug.WriteLine("mss","Warning \"" + openFile + "\" doesn't exist!");
                return true;
            }
            strSrc.Append("FILE__ = \"" + filepath + "\";\n");
            while (!sr.EndOfStream)
            {
                currLine++;
                string line = sr.ReadLine();
                if (line.Trim().ToLower().IndexOf("include") == 0)
                {
                    int debInc = line.IndexOf('"');
                    int endInc = line.IndexOf('"', debInc + 1);
                    string file = line.Substring(debInc + 1, endInc - debInc-1);

                    string myPath = Path.GetDirectoryName(path + "/" + filepath);
                    if (myPath == "")
                        myPath = ".";
                    load2(myPath,  file , strSrc);
                    strSrc.Append("FILE__ = \"" + filepath + "\";\n");
                    continue;
                }
                strSrc.Append("LINE__ = " + currLine.ToString() + ";\n");
                strSrc.Append(line + "\n" );
            }
            sr.Close();
            return true;

        }
        public bool tokenize(string strSrc)
        {
            Type TvarsLapper = varsLapper.GetType();
            FieldInfo FIvarsLapper;
//            FileStream file;
            Scanner scnr;
            string currFile = "";
            int currLine = 0;
            try
            {
                
//                file = new FileStream(filepath, FileMode.Open);
//                scnr = new Scanner(file);
                scnr = new Scanner();
                scnr.SetSource(strSrc, 0);
            }
            catch (System.Exception ev)
            {
                myDebug.WriteLine("err","Error on opening config file " + ev.Message);
                return false;
            }
            try
            {
                int tok;
                do
                {
                    tok = scnr.yylex();

//                    Console.WriteLine("#" + tok + ": " + scnr.yytext);
                    switch(tok){
                        case GLScript.Scanner.E_LANG:
                            {
                                if ((tok = scnr.yylex()) != GLScript.Scanner.E_STRING)
                                    throw (new System.Exception("Syntax error in cfg file Lang need lang id"));
                                string langId = UTILS.utils.unquote(scnr.yytext.ToLower());
                                while (true)
                                {
                                    tok = scnr.yylex();
                                    if (tok == GLScript.Scanner.E_ENDLANG)
                                        break;
                                    if (tok != GLScript.Scanner.E_IDENT)
                                        throw (new System.Exception("Syntax error in cfg file Need a item identification"));
                                    if (scnr.yytext == "FILE__")
                                    {
                                        tok = scnr.yylex(); //  = 
                                        tok = scnr.yylex(); // Value
                                        currFile = UTILS.utils.unquote(scnr.yytext);
                                        tok = scnr.yylex(); // ;
                                        continue;
                                    }
                                    if (scnr.yytext == "LINE__")
                                    {
                                        tok = scnr.yylex(); //  = 
                                        tok = scnr.yylex(); // Value
                                        currLine = int.Parse(scnr.yytext);
                                        tok = scnr.yylex(); // ;
                                        continue;
                                    }
                                    string itemId = scnr.yytext;
                                    if ((tok = scnr.yylex()) != GLScript.Scanner.E_ASSIGN)
                                        throw (new System.Exception("Syntax error in cfg file Need '=' "));
                                    string resultStr = "";
                                    while (true)
                                    {
                                        tok = scnr.yylex();
                                        if ( tok == GLScript.Scanner.E_STRING )
                                        {
                                            resultStr += UTILS.utils.unquote(scnr.yytext);
                                            continue;
                                        }
                                        if ( tok == GLScript.Scanner.E_POINT)
                                        {
                                            continue;
                                        }
                                        if (tok == GLScript.Scanner.E_SEMICOLON)
                                            break;
                                        if (tok == GLScript.Scanner.E_IDENT)
                                        {
                                            if (scnr.yytext == "FILE__")
                                            {
                                                tok = scnr.yylex(); //  = 
                                                tok = scnr.yylex(); // Value
                                                currFile = UTILS.utils.unquote(scnr.yytext);
                                                tok = scnr.yylex(); // ;
                                                continue;
                                            }
                                            if (scnr.yytext == "LINE__")
                                            {
                                                tok = scnr.yylex(); //  = 
                                                tok = scnr.yylex(); // Value
                                                currLine = int.Parse(scnr.yytext);
                                                tok = scnr.yylex(); // ;
                                                continue;
                                            }
                                        }
                                        string toto = scnr.yytext;
                                        throw (new System.Exception("Syntax error in cfg file Need string or '.' or ';'"));

                                    }
                                    lfsLang.AddItem(langId, itemId, resultStr);
                                }

                            }
                            break;

                        case GLScript.Scanner.E_BEGIN_FUNCTION:
                            {
                                string identName = scnr.yytext.ToLower();
//                                int lineCurr = scnr.GyyLine;
                                if ((tok = scnr.yylex()) != GLScript.Scanner.E_IDENT)
                                    throw (new System.Exception("Syntax error in cfg file Event need Event identification"));

                                string ev = scnr.yytext;

                                if (identName == "event" && !Enum.IsDefined(typeof(eventAllowed), ev))
                                    throw (new System.Exception("Event " + ev + " do not exist in LFSLapper"));

                                if ((tok = scnr.yylex()) != GLScript.Scanner.E_PAR_OPEN)
                                    throw (new System.Exception("Syntax error in cfg file Event need '(' in event :" + ev));
                                string buffParam = "";
                                while( ( tok = scnr.yylex()) != GLScript.Scanner.E_PAR_CLOSE ){
                                    if( tok == GLScript.Scanner.E_END || tok == GLScript.Scanner.E_SEMICOLON )
                                        throw (new System.Exception("Syntax error in cfg file Event need ')' in event :" + ev));
                                    buffParam += scnr.yytext;
                                }
                                string strBloc = "";
                                scnr.BEGIN(4);
                                while (true)
                                {
                                    tok = scnr.yylex();
                                    string str = scnr.yytext;
                                    if (tok == GLScript.Scanner.E_BEGIN_FUNCTION)
                                    {
                                        throw (new System.Exception("Unexpected function in event :" + ev));
                                    }
                                    if (tok == GLScript.Scanner.E_END_FUNCTION)
                                    {
                                        if (identName == "event" && str.ToLower() == "endevent")
                                            break;
                                        if (identName == "sub" && str.ToLower() == "endsub")
                                            break;
                                        throw (new System.Exception("Unexpected end function in event :" + ev));
                                    }
                                    strBloc += str;
                                }
                                scnr.BEGIN(0);

                                //Console.WriteLine("#" + tok + ": >----\n" + strBloc + "\n<------- ");
                                CurrApp.registerFunction(ev, strBloc, buffParam, currFile, currLine);
                            }
                            break;
                        case GLScript.Scanner.E_IDENT:
                            if (scnr.yytext == "FILE__")
                            {
                                tok = scnr.yylex(); //  = 
                                tok = scnr.yylex(); // Value
                                currFile = UTILS.utils.unquote(scnr.yytext);
                                tok = scnr.yylex(); // ;
                            }
                            else if (scnr.yytext == "LINE__")
                            {
                                tok = scnr.yylex(); //  = 
                                tok = scnr.yylex(); // Value
                                currLine = int.Parse( scnr.yytext );
                                tok = scnr.yylex(); // ;
                            }
                            else
                                throw (new System.Exception("Syntax error in cfg file :" + scnr.yytext));
                            break;
                        case GLScript.Scanner.E_VAR:
                            string idVar = scnr.yytext.Substring(1);    
                            if (scnr.yylex() != GLScript.Scanner.E_ASSIGN)
                                throw (new System.Exception("Syntax error in cfg file var $" + idVar + " need '='" ));

                            tok = scnr.yylex();
                            int typParam = tok;

                            string strVal = scnr.yytext;
                            if (tok == GLScript.Scanner.E_MOINS)
                            {
                                tok = scnr.yylex();
                                strVal += scnr.yytext;
                                typParam = GLScript.Scanner.E_INTEGER;
                            }
                            if (scnr.yylex() != GLScript.Scanner.E_SEMICOLON)
                                throw (new System.Exception("Syntax error in cfg file var $" + idVar + " need '; at end of line'" ));

                            FIvarsLapper = TvarsLapper.GetField(idVar);

                            if (FIvarsLapper == null)
                                throw (new System.Exception("Param var $" + idVar + " do    " ));

                            string typVarsLapper = FIvarsLapper.FieldType.Name;
                            if (typVarsLapper == "String" && typParam == GLScript.Scanner.E_IP)
                            {
//                                Console.WriteLine("Je set " + idVar + " Avec : " + strVal);
                                FIvarsLapper.SetValue(varsLapper, strVal);
                            }
                            else if (typVarsLapper == "String" && typParam == GLScript.Scanner.E_STRING)
                            {
                                FIvarsLapper.SetValue(varsLapper, strVal.Substring(1, strVal.Length - 2));
                            }
                            else if (typVarsLapper == "Int32" && typParam == GLScript.Scanner.E_INTEGER)
                            {
                                try
                                {
                                    FIvarsLapper.SetValue(varsLapper, int.Parse(strVal));
                                }
                                catch
                                {
                                    throw (new System.Exception("Var $" + idVar + " is wrong type. Need Integer value" ));
                                }
                            }
                            else if (typVarsLapper == "Double" && (typParam == GLScript.Scanner.E_INTEGER || typParam == GLScript.Scanner.E_FLOAT))
                            {
                                try
                                {
                                    FIvarsLapper.SetValue(varsLapper, double.Parse(strVal.Replace(".", System.Globalization.NumberFormatInfo.CurrentInfo.CurrencyDecimalSeparator)));
                                }
                                catch
                                {
                                    throw (new System.Exception("Var $" + idVar + " is wrong type. Need float value" ));
                                }
                            }
                            else if (typVarsLapper == "Boolean" && (strVal.ToLower() == "true" || strVal.ToLower() == "false"))
                            {
                                try
                                {
                                    FIvarsLapper.SetValue(varsLapper, bool.Parse(strVal));
                                }
                                catch
                                {
                                    throw (new System.Exception("Var $" + idVar + " is wrong type. Need true or false value" ));
                                }

                            }
                            else
                                throw (new System.Exception("Var $" + idVar + " is wrong type. Need " + typVarsLapper + " value" ));

                            CurrApp.GVAR.Set("ConfVar," + "\"" + idVar + "\"", new unionVal(0, "\"" + strVal + "\"", typVal.str));
                            CurrApp.GVAR.globVars["ConfVar"] = true;
//                            Console.WriteLine(idVar + " = " + FIvarsLapper.GetValue(varsLapper));
                            break;
                        case GLScript.Scanner.E_END:
//                            file.Close();
                            return true;
                        default:
                            throw (new System.Exception("Syntax error in cfg file line " + scnr.yytext + " Char " + scnr.yytext ));
                            


                    }
                } while (tok > (int)Tokens.EOF);
            }
            catch (System.Exception ev)
            {
                myDebug.WriteLine("err",ev.Message + " on file : \"" + currFile + "\" at line #" + currLine);
                return false;
            }
            return true;

        }


    }
}