/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.Text;

namespace LFSLapper
{
    public class Task
    {
        public readonly string Command;
        public readonly string Cron;
        public readonly bool IsOnceToExecuteOnly = true;

        int s = -1;
        int min = -1;
        int hr = -1;
        int day = -1;
        int dayOfWeek = -1;
        int mon = -1;
        int yr = -1;

        public Task(string Command, DateTime DateTime)
        {
            this.Command = Command;

            s = DateTime.Second;
            min = DateTime.Minute;
            hr = DateTime.Hour;
            day = DateTime.Day;
            mon = DateTime.Month;
            yr = DateTime.Year;

            IsOnceToExecuteOnly = true;
        }

        public Task(string Command, string CronSchedule )
        {
            this.Command = Command;
            this.Cron = CronSchedule;

            //parse CronSchedule
            System.Text.RegularExpressions.Regex regex = new System.Text.RegularExpressions.Regex(@"\d+|\*");
            System.Text.RegularExpressions.MatchCollection mc = regex.Matches(CronSchedule);

            if (!regex.IsMatch(CronSchedule) || mc.Count != 7)
                throw new Exception( "Error in RegisterScheduleAction " + Command + "in config file" );

            int val = 0;
            for (int i = 0; i < mc.Count; i++)
            {
                if (mc[i].Value == "*")
                {
                    val = -1;
                    IsOnceToExecuteOnly = false;
                }
                else
                    val = int.Parse(mc[i].Value);

                switch (i)
                {
                    case 0: this.s = val; break;
                    case 1: this.min = val; break;
                    case 2: this.hr = val; break;
                    case 3: this.dayOfWeek = val; break;
                    case 4: this.day = val; break;
                    case 5: this.mon = val; break;
                    case 6: this.yr = val; break;
                    default: throw new Exception("Too many fields in schedule");
                }
            }

        }

        bool Equals(DateTime dt)
        {
            return
                (dt.Year == yr || yr == -1) &&
                (dt.Month == mon || mon == -1) &&
                (dt.Day == day || day == -1) &&
                ((int)dt.DayOfWeek == dayOfWeek || dayOfWeek == -1) &&
                (dt.Hour == hr || hr == -1) &&
                (dt.Minute == min || min == -1) &&
                (dt.Second == s || s == -1);
        }

        public bool IsToExecuteNow()
        {
            return this.Equals(System.DateTime.Now);
        }
    }
}
