/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

using System;
using System.IO;
using System.Diagnostics;
using System.Collections;
using System.Reflection;
using System.Text.RegularExpressions;
using Configurator;



namespace LFSLapper
{
    class LFSLapper
    {
        static GLDebug.Debug myDebug;

        #region Main

        /// <summary>
        /// References GNU GPL License
        /// </summary>
        public static string getShortVersion(int level)
        {
            string[] FullNameSplit = System.Reflection.Assembly.GetExecutingAssembly().FullName.Split(',');
            string[] version = FullNameSplit[1].Trim().Split('=');
            string[] id = version[1].Split('.');
            string retVal = id[0];
            for (int i = 1; i < level; i++)
                retVal += "." + id[i];
            return retVal;
        }

        static void PrintLicense()
        {
            Console.WriteLine("LFSLapper Version=" + getShortVersion(4) + " on GNU license");
            Console.WriteLine("2005-2008 Janez Cufer and Robert BRACCAGNI ( Gai-Luron )");
            Console.WriteLine("LFSLapper comes with ABSOLUTELY NO WARRANTY");
            Console.WriteLine("This is free software, and you are welcome to redistribute it");
            Console.WriteLine("under certain conditions. Read LICENSE for details.");
            Console.WriteLine();
            myDebug.WriteLine("mss", "Started - LFSLapper Version=" + getShortVersion(4));
        }

        /// <summary>
        /// Prints command line usage with license.
        /// </summary>
        static void PrintUsage()
        {
        }

        static void Main(string[] Args)
        {

            ArrayList listOfLFSInstance = new ArrayList();
            System.Globalization.CultureInfo oldCult = System.Threading.Thread.CurrentThread.CurrentCulture;
            System.Threading.Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo("en-US");

            try
            {
                #region testGLScript
/*
                if (false)
                {
                   
                    GLScript.GLApp myApp = new GLScript.GLApp("Test Application", null);
                    myApp.registerFunction("maFonction", "writeLine( \"coucou\");\nreturn(\"Voil un test: \" . $a . \" --- Glob Var: \" . $toto[1]);\nwriteLine( \"caca\");", "$a","", 1);

                    ArrayList argVals = new ArrayList();
                    argVals.Add("10");
                    argVals.Add("Argument2");
                    myApp.executeFunction("maFonction", (string[])argVals.ToArray(typeof(string)));

                    System.Console.WriteLine("Appuyez sur une touche");
                    System.Console.ReadKey();
                    Environment.Exit(0);
                }
*/
                #endregion
                myDebug = new GLDebug.Debug("./logs");
                myDebug.AddDebugOutput("err", "LFSLapper-ERR.log");
                myDebug.AddDebugOutput("mss", "LFSLapper-MSS.log");
                if (false)
                {
                    LFSDbs.storedDbs myStoredDbs = new LFSDbs.storedDbs(myDebug, "testStored");
                    ArrayList myArray = myStoredDbs.GetTable("testKey%", 0, "gai-luron", 18, "", true );
                    return;
                }
                else
                {
                    PrintLicense();

                    UTILS.utils.initUtils();

                    string[] fileCfg = new string[100];

                    // Start the command serveur for this LFSLapper

                    LapperServer.Server TCPServ = new LapperServer.Server(myDebug); // Start the TCP Server for command

                    ConsoleCmd.readCmd(TCPServ.lapperServerPass, "127.0.0.1", TCPServ.remotePort, "Quitting LFSLapper and close all instances!");

                    TCPServ.stop();
                    //                System.Threading.Thread.CurrentThread.CurrentCulture = oldCult;
                    myDebug.WriteLine("mss", "Stopped - LFSLapper Version=" + getShortVersion(4));

                }
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error in LFSLapper. Look at " + myDebug.getFileName("err"));
                myDebug.printDateOnEachLine = false;
                myDebug.WriteSeparator("err");
                myDebug.WriteLineDate("err");
                myDebug.WriteLine( "err","The following error occurred in " + ex.Source);
                myDebug.WriteLine( "err",ex.Message);   // Print the error message.
                myDebug.WriteLine( "err",ex.StackTrace); //String that contains the stack trace for this exception.
                myDebug.WriteLine( "err",ex.TargetSite.ToString()); //String that contains the stack trace for this exception.
                myDebug.WriteLine( "err","");
                myDebug.WriteSeparator("err");
                myDebug.printDateOnEachLine = true;
                System.Threading.Thread.Sleep(15000);
                
            }
        }
        #endregion
    }


}
