/*
    LFSLapper, Insim Utilities for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;


namespace GLScript
{
    public class ParseException : Exception
    {
        public ParseException(string message) : base(message) { }
        public ParseException(string message, Exception innerException) : base(message, innerException) { }
    }

    public class unionVal
    {
        public float fval;
        public string sval;
        public typVal typVal;
        public string nameVar;
        public ArrayList ArgsVals = new ArrayList();
        public unionVal(float pfval, string psval, typVal ptypval)
        {
            this.fval = pfval;
            this.sval = psval;
            this.typVal = ptypval;
        }

    }
    public enum typVal
    {
        num,
        str,
        var,
        arrayVar,
        ident,
        function,
        undef,
    }

    class Parseur
    {

        private enum tokenExpr
        {
            notfound,
            assign,
            and,
            or,
            boolAnd,
            boolOr,
            equal,
            diff,
            moreThan,
            lessThan,
            moreThanEqual,
            lessThanEqual,
            concat,
            plus,
            minus,
            mult,
            div,
            pow,
            nbVal,
        }
        private Parseur expra;
        private Parseur exprb;
        private tokenExpr operateur;
        

        public unionVal val = new unionVal(0, "", typVal.undef);

        public Parseur( string fileName, string strSrc )
        {
            TokenBuffer tkbuff = new TokenBuffer(strSrc,fileName, 1);
            goParse(tkbuff, 0, tkbuff.TokenList.Count - 1);
        }
        public Parseur( TokenBuffer ptokens)
        {
            goParse(ptokens, 0, ptokens.TokenList.Count - 1);
        }
        public Parseur( TokenBuffer ptokens, int pstartBloc, int pendBloc )
        {
            goParse(ptokens, pstartBloc, pendBloc );
        }
        private void goParse(TokenBuffer tokens, int startBloc, int endBloc)
        {
            TokenBuffer.token myToken;
            this.expra = null;
            this.exprb = null;
            this.operateur = tokenExpr.notfound;

            int nbToken = endBloc - startBloc + 1;
/*
            if (false)
            {
                for (int i = startBloc; i <= endBloc; i++)
                {
                    myToken = (TokenBuffer.token)tokens.TokenList[i];
                    Console.Write(myToken.value);
                }
                Console.WriteLine();
            }
*/
            if ( nbToken == 0 )
            {
                this.val.sval = "\"\"";
                this.val.typVal = typVal.str;
                return;
            }
            if ( nbToken == 1 )
            {
                myToken = (TokenBuffer.token)tokens.TokenList[startBloc];
                if (myToken.typ == Scanner.E_STRING)
                {
                    this.val.sval = myToken.value;
                    this.val.typVal = typVal.str;
                }
                else if (myToken.typ == Scanner.E_VAR)
                {
                    this.val.typVal = typVal.var;
                    this.val.sval = myToken.value.Substring(1);
                    this.val.nameVar = myToken.value.Substring(1);
                }
                else if (myToken.typ == Scanner.E_INTEGER || myToken.typ == Scanner.E_FLOAT)
                {
                    this.val.fval = float.Parse(myToken.value);
                    this.val.typVal = typVal.num;
                }
                else if (myToken.typ == Scanner.E_IDENT)
                {
                    this.val.typVal = typVal.str;
                    this.val.sval = "\"" + myToken.value + "\"";
                }
                return;
            }
            myToken = (TokenBuffer.token)tokens.TokenList[startBloc];
            if (myToken.typ == Scanner.E_VAR)
            {
                int brack = 0;
                int par = 0;
                int cpt;
                for (cpt = startBloc + 1; cpt <= endBloc; cpt++)
                {
                    if ((tokens.TokenList[cpt] as TokenBuffer.token).typ == Scanner.E_BRACKET_OPEN)
                        brack++;
                    if ((tokens.TokenList[cpt] as TokenBuffer.token).typ == Scanner.E_BRACKET_CLOSE)
                        brack--;
                    if (brack == 0)
                        break;
                }
                if (brack == 0 && cpt == endBloc && (tokens.TokenList[endBloc] as TokenBuffer.token).typ == Scanner.E_BRACKET_CLOSE)
                {
                    this.val.typVal = typVal.arrayVar;
                    this.val.sval = myToken.value.Substring(1);
                    this.val.nameVar = myToken.value.Substring(1);

                    int start = startBloc + 2;
                    par = 0;
                    brack = 0;
                    for (int i = startBloc + 2; i <= endBloc; i++)
                    {
                        myToken = (TokenBuffer.token)tokens.TokenList[i];
                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_PAR_OPEN)
                            par++;
                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_PAR_CLOSE)
                            par--;

                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_BRACKET_OPEN)
                            brack++;
                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_BRACKET_CLOSE)
                            brack--;

                        if ( ( myToken.typ == Scanner.E_COLON || i == endBloc - 1 ) && par == 0 && brack == 0)
                        {
                            if (i == endBloc - 1)
                                i++;
                            // Parser l'argument
                            this.val.ArgsVals.Add( new Parseur(tokens, start, i - 1) );
                            start = i + 1;
                        }

                    }
                    return;
                }
            }
            if (myToken.typ == Scanner.E_IDENT)
            {
                int par = 0;
                int brack = 0;

                int cpt;
                for (cpt = startBloc + 1; cpt <= endBloc; cpt++)
                {
                    if ((tokens.TokenList[cpt] as TokenBuffer.token).typ == Scanner.E_PAR_OPEN)
                        par++;
                    if ((tokens.TokenList[cpt] as TokenBuffer.token).typ == Scanner.E_PAR_CLOSE)
                        par--;

                    if (par == 0 )
                        break;
                }
                if (par == 0 && cpt == endBloc && (tokens.TokenList[endBloc] as TokenBuffer.token).typ == Scanner.E_PAR_CLOSE)
                {
                    this.val.typVal = typVal.function;
                    this.val.sval = "";
                    this.val.nameVar = myToken.value;

                    
                    int start = startBloc + 2;
                    par = 0;
                    brack = 0;
                    for (int i = startBloc + 2; i <= endBloc; i++)
                    {
                        myToken = (TokenBuffer.token)tokens.TokenList[i];
                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_PAR_OPEN)
                            par++;
                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_PAR_CLOSE)
                            par--;

                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_BRACKET_OPEN)
                            brack++;
                        if ((tokens.TokenList[i] as TokenBuffer.token).typ == Scanner.E_BRACKET_CLOSE)
                            brack--;

                        if ( ( myToken.typ == Scanner.E_COLON || i == endBloc - 1 ) && par == 0 && brack == 0)
                        {
                            if (i == endBloc - 1)
                                i++;
                            // Parser l'argument
                            this.val.ArgsVals.Add(new Parseur(tokens, start, i - 1));
                            start = i + 1;
                        }

                    }
                    return;
                }
            }
            this.val.typVal = typVal.undef;
            int p = 0;
            int cp0 = 0;
            //on recupere la liste des operateurs
            bool[] operateurs = new bool[(int)tokenExpr.nbVal];

            for (int i = 0; i < (int)tokenExpr.nbVal; i++)
                operateurs[i] = true;

            //on recupere la liste des operateurs
            for (int i = startBloc; i <= endBloc; i++)
            {
                myToken = (TokenBuffer.token)tokens.TokenList[i];
                if (myToken.typ == Scanner.E_END)
                    break;
                if (myToken.typ == Scanner.E_PAR_OPEN)
                    p++;
                else if (myToken.typ == Scanner.E_PAR_CLOSE)
                    p--;
                else if (p == 0)
                {
                    tokenExpr token = tokenExpr.notfound;
                    if (myToken.typ == Scanner.E_ASSIGN)
                        token = tokenExpr.assign;
                    else if (myToken.typ == Scanner.E_AND)
                        token = tokenExpr.and;
                    else if (myToken.typ == Scanner.E_OR)
                        token = tokenExpr.or;
                    else if (myToken.typ == Scanner.E_BOOL_AND)
                        token = tokenExpr.boolAnd;
                    else if (myToken.typ == Scanner.E_BOOL_OR)
                        token = tokenExpr.boolOr;
                    else if (myToken.typ == Scanner.E_EQUAL)
                        token = tokenExpr.equal;
                    else if (myToken.typ == Scanner.E_DIFF)
                        token = tokenExpr.diff;
                    else if (myToken.typ == Scanner.E_MORE_EQUAL)
                        token = tokenExpr.moreThanEqual;
                    else if (myToken.typ == Scanner.E_LESS_EQUAL)
                        token = tokenExpr.lessThanEqual;
                    else if (myToken.typ == Scanner.E_MORE)
                        token = tokenExpr.moreThan;
                    else if (myToken.typ == Scanner.E_LESS)
                        token = tokenExpr.lessThan;
                    else if (myToken.typ == Scanner.E_POINT)
                        token = tokenExpr.concat;
                    else if (myToken.typ == Scanner.E_PLUS)
                        token = tokenExpr.plus;
                    else if (myToken.typ == Scanner.E_MOINS)
                        token = tokenExpr.minus;
                    else if (myToken.typ == Scanner.E_MULT)
                        token = tokenExpr.mult;
                    else if (myToken.typ == Scanner.E_DIV)
                        token = tokenExpr.div;
                    else if (myToken.typ == Scanner.E_POW)
                        token = tokenExpr.pow;
                    if (token != tokenExpr.notfound)
                    {
                        for (int j = (int)token + 1; j < (int)tokenExpr.nbVal; j++)
                            operateurs[j] = false;
                    }
                }
            }
            if (p != 0)
            {
                throw new ParseException("Incorrect number of parenthesis");
            }
            for (int i = endBloc; i >= startBloc; i--)
            {
                myToken = (TokenBuffer.token)tokens.TokenList[i];
                if (myToken.typ == Scanner.E_END)
                    continue;

                if (p == 0)
                {
                    cp0++;
                }
                tokenExpr token = tokenExpr.notfound;
                if (myToken.typ == Scanner.E_ASSIGN)
                    token = tokenExpr.assign;
                else if (myToken.typ == Scanner.E_AND)
                    token = tokenExpr.and;
                else if (myToken.typ == Scanner.E_OR)
                    token = tokenExpr.or;
                else if (myToken.typ == Scanner.E_BOOL_AND)
                    token = tokenExpr.boolAnd;
                else if (myToken.typ == Scanner.E_BOOL_OR)
                    token = tokenExpr.boolOr;
                else if (myToken.typ == Scanner.E_EQUAL)
                    token = tokenExpr.equal;
                else if (myToken.typ == Scanner.E_DIFF)
                    token = tokenExpr.diff;
                else if (myToken.typ == Scanner.E_MORE_EQUAL)
                    token = tokenExpr.moreThanEqual;
                else if (myToken.typ == Scanner.E_LESS_EQUAL)
                    token = tokenExpr.lessThanEqual;
                else if (myToken.typ == Scanner.E_MORE)
                    token = tokenExpr.moreThan;
                else if (myToken.typ == Scanner.E_LESS)
                    token = tokenExpr.lessThan;
                else if (myToken.typ == Scanner.E_POINT)
                    token = tokenExpr.concat;
                else if (myToken.typ == Scanner.E_PLUS)
                    token = tokenExpr.plus;
                else if (myToken.typ == Scanner.E_MOINS)
                    token = tokenExpr.minus;
                else if (myToken.typ == Scanner.E_MULT)
                    token = tokenExpr.mult;
                else if (myToken.typ == Scanner.E_DIV)
                    token = tokenExpr.div;
                else if (myToken.typ == Scanner.E_POW)
                    token = tokenExpr.pow;

                if (myToken.typ == Scanner.E_PAR_OPEN)
                    p++;
                else if (myToken.typ == Scanner.E_PAR_CLOSE)
                    p--;
                else if (p == 0 && (token != tokenExpr.notfound) && (bool)operateurs[(int)token])
                {
                    this.operateur = token;
                    this.expra = new Parseur(tokens,startBloc,i-1);
                    this.exprb = new Parseur(tokens,i+1,endBloc);
                    break;
                }
            }

            if (this.expra == null && cp0 == 1)
            {
                myToken = (TokenBuffer.token)tokens.TokenList[startBloc];
                if (( endBloc - startBloc +1 ) == 3)
                {
                    TokenBuffer.token myToken2 = (TokenBuffer.token)tokens.TokenList[startBloc + 1];
                    if (myToken2.typ == Scanner.E_STRING)
                    {
                        this.val.sval = myToken2.value;
                        this.val.typVal = typVal.str;
                    }
                    else if (myToken2.typ == Scanner.E_VAR)
                    {
                        this.val.sval = myToken2.value;
                        this.val.typVal = typVal.var;
                    }
                    else if (myToken2.typ == Scanner.E_INTEGER || myToken2.typ == Scanner.E_FLOAT)
                    {
                        this.val.fval = float.Parse(myToken2.value);
                        this.val.typVal = typVal.num;
                    }
                }
                else
                {
                    this.expra = new Parseur( tokens,startBloc+1,endBloc-1 );
                }
            }
        }

        public string ToRPN()
        {
            if (this.val.typVal != typVal.undef)
            {
                if (this.val.typVal == typVal.num)
                    return this.val.fval.ToString();
                else if (this.val.typVal == typVal.str)
                    return this.val.sval;
                else if (this.val.typVal == typVal.var)
                    return this.val.sval;
                else if (this.val.typVal == typVal.arrayVar)
                {
                    return this.val.nameVar + "[" + "]";
                }
                else if (this.val.typVal == typVal.function)
                    return this.val.nameVar;
            }
            else if (this.exprb == null && this.expra != null)
            {
                return this.expra.ToRPN();
            }
            else if (this.expra == null && this.exprb != null)
            {
                if (this.operateur != tokenExpr.notfound)
                    return this.exprb.ToRPN() + " " + this.operateur;
                else
                    return this.exprb.ToRPN();
            }
            else if (this.expra != null && this.exprb != null)
            {
                return this.expra.ToRPN() + " " + this.exprb.ToRPN() + " " + this.operateur;
            }
            return "";
        }
        private float numval(string str)
        {
            try
            {
                float val = float.Parse(str);
                return val;
            }
            catch
            {
                return 0;
            }
        }
        public delegate void executeParsedFunction(SetOfVars gv, SetOfVars lv, unionVal var, ArrayList ar );
        public unionVal getval(SetOfVars GVAR, SetOfVars LVAR, executeParsedFunction BC)
        {
            if (this.val.typVal != typVal.undef)
            {
                if (this.val.typVal == typVal.var || this.val.typVal == typVal.arrayVar)
                    replaceVarByValue( this.val, GVAR, LVAR, BC );
                if (this.val.typVal == typVal.function )
                    BC( GVAR,LVAR,this.val,retreiveArgs( GVAR, LVAR,BC ) );
                return this.val;
            }
            else if (this.exprb == null)
            {
                if (this.expra == null)
                    throw new ParseException("suspected error in order of the operators");
                else
                    return this.expra.getval(GVAR, LVAR,BC);
            }
            unionVal reta = this.expra.getval(GVAR, LVAR,BC );
            unionVal retb = this.exprb.getval( GVAR, LVAR, BC);
            if (this.operateur != tokenExpr.assign)
            {
                if (reta.typVal == typVal.var || reta.typVal == typVal.arrayVar )
                    replaceVarByValue(reta,GVAR, LVAR,BC );
                if (retb.typVal == typVal.var || reta.typVal == typVal.arrayVar )
                    replaceVarByValue(retb, GVAR, LVAR,BC);
            }
            if (reta.typVal == typVal.function )
                BC(GVAR, LVAR, reta, retreiveArgs(GVAR, LVAR, BC));
            if (retb.typVal == typVal.function )
                BC(GVAR, LVAR, retb, retreiveArgs(GVAR, LVAR, BC));
            if (this.operateur == tokenExpr.equal
                || this.operateur == tokenExpr.diff
                || this.operateur == tokenExpr.moreThan
                || this.operateur == tokenExpr.lessThan
                || this.operateur == tokenExpr.moreThanEqual
                || this.operateur == tokenExpr.lessThanEqual
                )
            {
                if (reta.typVal == typVal.str || retb.typVal == typVal.str)
                {
                    if (reta.typVal != typVal.str)
                    {
                        reta.typVal = typVal.str;
                        reta.sval = "\"" + reta.fval.ToString() + "\"";
                    }
                    if (retb.typVal != typVal.str)
                    {
                        retb.typVal = typVal.str;
                        retb.sval = "\"" + retb.fval.ToString() + "\"";
                    }
                }

            }
            if (this.operateur == tokenExpr.concat)
            {
                if (reta.typVal == typVal.num)
                {
                    reta.sval = "\"" + reta.fval.ToString() + "\"";
                    reta.typVal = typVal.str;
                }
                if (retb.typVal == typVal.num)
                {
                    retb.sval = "\"" + retb.fval.ToString() + "\"";
                    retb.typVal = typVal.str;
                }
            }
            if (this.operateur == tokenExpr.plus
                || this.operateur == tokenExpr.or
                || this.operateur == tokenExpr.and
                || this.operateur == tokenExpr.minus
                || this.operateur == tokenExpr.mult
                || this.operateur == tokenExpr.div
                || this.operateur == tokenExpr.boolAnd
                || this.operateur == tokenExpr.boolOr
                || this.operateur == tokenExpr.pow
                )
            {
                if (reta.typVal == typVal.str)
                {
                    reta.fval = this.numval(unquote(reta.sval));
                    reta.typVal = typVal.num;
                }
                if (retb.typVal == typVal.str)
                {
                    retb.fval = this.numval(unquote(retb.sval));
                    retb.typVal = typVal.num;
                }
            }
            switch (this.operateur)
            {
                case tokenExpr.assign:
                    // Faire ici l'assignation
                    unionVal retValue = new unionVal(retb.fval, retb.sval, retb.typVal);
                    assignValueToVar(reta, retValue, GVAR, LVAR,BC);
                    return retValue;
                case tokenExpr.and:
                    if (reta.fval != 0 && retb.fval != 0)
                        return new unionVal(1, "", typVal.num);
                    else
                        return new unionVal(0, "", typVal.num);
                case tokenExpr.or:
                    if (reta.fval != 0 || retb.fval != 0)
                        return new unionVal(1, "", typVal.num);
                    else
                        return new unionVal(0, "", typVal.num);
                case tokenExpr.equal:
                    if (reta.typVal == typVal.str)
                    {
                        if (reta.sval == retb.sval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval == retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.diff:
                    if (reta.typVal == typVal.str)
                    {
                        if (reta.sval != retb.sval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval != retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.moreThan:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) > 0)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval > retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.moreThanEqual:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) >= 0)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval >= retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.lessThan:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) < 0)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval < retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                case tokenExpr.lessThanEqual:
                    if (reta.typVal == typVal.str)
                    {
                        if (string.Compare(reta.sval, retb.sval) <= 0)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }
                    else
                    {
                        if (reta.fval <= retb.fval)
                            return new unionVal(1, "", typVal.num);
                        else
                            return new unionVal(0, "", typVal.num);
                    }

                case tokenExpr.concat:
                    return new unionVal(0, "\"" + unquote(reta.sval) + unquote(retb.sval) + "\"", typVal.str);
                case tokenExpr.plus:
                        return new unionVal(reta.fval + retb.fval, "", typVal.num);
                case tokenExpr.minus:
                    return new unionVal(reta.fval - retb.fval, "", typVal.num);
                case tokenExpr.mult:
                    return new unionVal(reta.fval * retb.fval, "", typVal.num);
                case tokenExpr.div:
                    if (retb.fval == 0)
                        throw new ParseException("Division par 0");
                    return new unionVal(reta.fval / retb.fval, "", typVal.num);
                case tokenExpr.boolAnd:
                    return new unionVal((float)((int)reta.fval & (int)retb.fval), "", typVal.num);
                case tokenExpr.boolOr:
                    return new unionVal((float)((int)reta.fval | (int)retb.fval), "", typVal.num);
                case tokenExpr.pow:
                    {
                        if (retb.fval == 0)
                        {
                            return new unionVal(1, "", typVal.num);
                        }
                        else if (reta.fval == 0)
                        {
                            return new unionVal(0, "", typVal.num);
                        }
                        else if (retb.fval != Math.Ceiling(retb.fval) && reta.fval <= 0)
                        {
                            if ((1 / retb.fval) == Math.Ceiling(1 / retb.fval) && Math.Abs(1 / retb.fval) % 2 == 1)
                            {
                                return new unionVal((float)(-Math.Pow(-reta.fval, retb.fval)), "", typVal.num);
                            }
                            else
                            {
                                throw new ParseException("On ne peut pas prendre un exposant non entier sur un nombre negatif");
                            }
                        }
                        else
                        {
                            return new unionVal((float)Math.Pow(reta.fval, Math.Ceiling(retb.fval)), "", typVal.num);
                        }
                    }
                default:
                    throw new ParseException("operateur " + this.operateur + "non definit");
            }
        }
        ArrayList retreiveArgs(SetOfVars GVAR, SetOfVars LVAR, executeParsedFunction BC)
        {
            ArrayList ArRet = new ArrayList();
            for (int i = 0; i < val.ArgsVals.Count; i++)
            {
                unionVal arg = (val.ArgsVals[i] as Parseur).getval(GVAR, LVAR, BC);
                if( arg.typVal == typVal.num )
                    ArRet.Add( arg.fval.ToString());
                else
                    ArRet.Add(unquote( arg.sval ));
            }
            return ArRet;
        }
        void replaceVarByValue(unionVal val, SetOfVars GVAR, SetOfVars LVAR, executeParsedFunction BC)
        {
            string idVar = val.nameVar;
            for( int i = 0; i < val.ArgsVals.Count;i++ )
            {
                unionVal index = (val.ArgsVals[i] as Parseur).getval(GVAR, LVAR,BC );
                if (index.typVal == typVal.num)
                    idVar = idVar + "," + index.fval.ToString();
                else
                    idVar = idVar + "," + index.sval;
            }
            unionVal myVar;
            if( GVAR.globalExist( idVar ))
                myVar = (unionVal)GVAR.Get(idVar);
            else
                myVar = (unionVal)LVAR.Get(idVar);
            if (myVar == null)
            {
                val.typVal = typVal.str;
                val.sval = "\"\"";
                val.fval = 0;
            }
            else
            {
                val.typVal = myVar.typVal;
                val.sval = myVar.sval;
                val.fval = myVar.fval;
            }
        }
        void assignValueToVar(unionVal val, unionVal retValue, SetOfVars GVAR, SetOfVars LVAR, executeParsedFunction BC)
        {
            string idVar = val.nameVar;
            for (int i = 0; i < val.ArgsVals.Count; i++)
            {
                unionVal index = (val.ArgsVals[i] as Parseur).getval(GVAR, LVAR, BC);
                if (index.typVal == typVal.str)
                    idVar = idVar + "," + index.sval.ToString();
                else
                    idVar = idVar + "," + index.fval.ToString();
            }
            if (GVAR.globalExist(idVar))
                GVAR.Set(idVar, retValue);
            else
                LVAR.Set(idVar, retValue);
        }

        private static string unquote(string str)
        {
            int l = str.Length;
            try
            {
               return str.Substring(1, l - 2);
            }
            catch
            {
                return "";
            }
        }
    }


}
