/*
This is a simple parser for html.  It tries to turn the html into something that
can be displayed by a wiki.
 */

%namespace GLScript
%option noparser
%using System.Text;


%x COMMENT
%x COMMENTSHARP
%x BLOCCMD
%x BLOCFUNC



ALPHA [A-Za-z]
DIGIT [0-9]
NONNEWLINE_WHITE_SPACE_CHAR [\ \r\t\b\012]
WHITE_SPACE_CHAR [\n\r\ \t\b\012]
STRING_TEXT (\\\"|[^\n\"]|\\{WHITE_SPACE_CHAR}+\\)*
COMMENT_TEXT ([^/*\n]|[^*\n]"/"[^*\n]|[^/\n]"*"[^/\n]|"*"[^/\n]|"/"[^*\n])*
COMMENT_TEXT_SHARP ([^\n])*
BLOC_TEXT [^\n\r]*
VAR ${ALPHA}(({ALPHA}|{DIGIT}|_)*)


%%

<INITIAL> "," { GyyLine = yyline;return E_COLON; }
<INITIAL> ":" { GyyLine = yyline;return E_DOUBLEDOT; }
<INITIAL> ";" { GyyLine = yyline;return E_SEMICOLON; }
<INITIAL> "(" { GyyLine = yyline;return E_PAR_OPEN; }
<INITIAL> ")" { GyyLine = yyline;return E_PAR_CLOSE; }
<INITIAL> "[" { GyyLine = yyline;return E_BRACKET_OPEN; }
<INITIAL> "]" { GyyLine = yyline;return E_BRACKET_CLOSE; }
/* <INITIAL> "{" { GyyLine = yyline;return 7; } */
/* <INITIAL> "}" { GyyLine = yyline;return 8; } */
<INITIAL> "." { GyyLine = yyline;return E_POINT; }
<INITIAL> "+" { GyyLine = yyline;return E_PLUS; }
<INITIAL> "-" { GyyLine = yyline;return E_MOINS; }
<INITIAL> "*" { GyyLine = yyline;return E_MULT; }
<INITIAL> "/" { GyyLine = yyline;return E_DIV; }
<INITIAL> "=" { GyyLine = yyline;return E_ASSIGN; }
<INITIAL> "==" { GyyLine = yyline;return E_EQUAL; }
<INITIAL> "<>" { GyyLine = yyline;return E_DIFF; }
<INITIAL> "<"  { GyyLine = yyline;return E_LESS; }
<INITIAL> "<=" { GyyLine = yyline;return E_LESS_EQUAL; }
<INITIAL> ">"  { GyyLine = yyline;return E_MORE; }
<INITIAL> ">=" { GyyLine = yyline;return E_MORE_EQUAL; }
<INITIAL> "&"  { GyyLine = yyline;return E_BOOL_AND; }
<INITIAL> "|"  { GyyLine = yyline;return E_BOOL_OR; }
<INITIAL> "&&"  { GyyLine = yyline;return E_AND; }
<INITIAL> "||"  { GyyLine = yyline;return E_OR; }
<INITIAL> "!=" { GyyLine = yyline;return E_DIFF; }
<INITIAL> "\^" { GyyLine = yyline;return E_POW; }
<INITIAL> "§" { GyyLine = yyline;return 23; }
<INITIAL,BLOCFUNC> [eE][vV][eE][nN][tT]|[sS][uU][bB] { GyyLine = yyline;return E_BEGIN_FUNCTION; }
<INITIAL,BLOCFUNC> [eE][nN][dD][eE][vV][eE][nN][tT]|[eE][nN][dD][sS][uU][bB] { GyyLine = yyline;return E_END_FUNCTION; }
<INITIAL> [bB][rR][eE][aA][kK] { GyyLine = yyline;return E_BREAK; }
<INITIAL> [fF][oO][rR] { GyyLine = yyline;return E_FOR; }
<INITIAL> [sS][wW][iI][tT][cC][hH] { GyyLine = yyline;return E_SWITCH; }
<INITIAL> [cC][aA][sS][eE] { GyyLine = yyline;return E_CASE; }
<INITIAL> [eE][nN][dD][sS][wW][iI][tT][cC][hH] { GyyLine = yyline;return E_ENDSWITCH; }
<INITIAL> [dD][eE][fF][aA][uU][lL][tT] { GyyLine = yyline;return E_DEFAULT; }
<INITIAL> [eE][nN][dD][fF][oO][rR] { GyyLine = yyline;return E_ENDFOR; }
<INITIAL> [wW][hH][iI][lL][eE] { GyyLine = yyline;return E_WHILE; }
<INITIAL> [eE][nN][dD][wW][hH][iI][lL][eE] { GyyLine = yyline;return E_ENDWHILE; }
<INITIAL> [iI][fF] { GyyLine = yyline;return E_IF; }
<INITIAL> [tT][hH][eE][nN] { GyyLine = yyline;return E_THEN; }
<INITIAL> [eE][lL][sS][eE] { GyyLine = yyline;return E_ELSE; }
<INITIAL> [eE][nN][dD][iI][fF] { GyyLine = yyline;return E_ENDIF; }
<INITIAL> [gG][lL][oO][bB][aA][lL][vV][aA][rR] { GyyLine = yyline;return E_GLOBALVAR; }
<INITIAL> [lL][aA][nN][gG] { GyyLine = yyline;return E_LANG; }
<INITIAL> [eE][nN][dD][lL][aA][nN][gG] { GyyLine = yyline;return E_ENDLANG; }
/* <INITIAL> [rR][eE][tT][uU][rR][nN] { GyyLine = yyline;return E_RETURN; } */
/* <INITIAL> [pP][lL][aA][yY][eE][rR][vV][aA][rR] { GyyLine = yyline;return E_PLAYERVAR; } */
<INITIAL> {NONNEWLINE_WHITE_SPACE_CHAR}+ { }

/*
<INITIAL,INITIAL> \n {
	if( comment_sharp ){
	  comment_sharp = false;
		BEGIN(INITIAL);
	}
		break;
}
*/
<INITIAL> "}" {
//	Console.WriteLine("Error unmatched '}' at line #" + yyline);
	Utility.assert(false,"Error unmatched '}'");

}
<INITIAL> "{" {
								BEGIN(BLOCCMD);
								bloc_count++;
								strBloc = "";
								break;
}
<INITIAL> "#" { BEGIN(COMMENTSHARP);break; }
<INITIAL> "/*" { BEGIN(COMMENT); comment_count = comment_count + 1;break; }

<COMMENTSHARP> "\n" { BEGIN(INITIAL);break; }

<BLOCCMD> "{" {
								bloc_count++;
								strBloc += "{";
								break;
					}
<BLOCCMD> "}" {
	bloc_count--;
	if (bloc_count == 0) {
    		BEGIN(INITIAL);
    		GyyLine = yyline;
    		return E_BLOC;

	}
	else
			strBloc += "}";
	break;
}
<COMMENT> "/*" { comment_count = comment_count + 1;break; }
<COMMENT> "*/" {
	comment_count = comment_count - 1;
	Utility.assert(comment_count >= 0, "To much ')'");
	if (comment_count == 0) {
    		BEGIN(INITIAL);

	}
	break;
}
<COMMENTSHARP> {COMMENT_TEXT_SHARP} { }
<COMMENT> {COMMENT_TEXT} { }
<BLOCCMD> {BLOC_TEXT} {
	strBloc += yytext;
}
<BLOCFUNC> {BLOC_TEXT} {
	return E_BLOC;
}
<BLOCFUNC> "\n" {
	return E_BLOC;
}

<INITIAL> \"{STRING_TEXT}\" {
	string str =  yytext.Substring(1,yytext.Length - 2);

	Utility.assert(str.Length == yytext.Length - 2, "Error on '\"'");
//	Console.WriteLine( "String " + yytext);
	GyyLine = yyline;
	return E_STRING;
}
<INITIAL> \"{STRING_TEXT} {
//	string str =  yytext.Substring(1,yytext.Length);

//	Utility.error(yyline,Utility.E_UNCLOSEDSTR);
	Utility.assert(false,"Unclosed string");
	break;
//	return 41;
}
<INITIAL> {DIGIT}+ {
	GyyLine = yyline;
	return E_INTEGER;
}
<INITIAL> {ALPHA}({ALPHA}|{DIGIT}|_)* {
	GyyLine = yyline;
	return E_IDENT;
}
<INITIAL> {DIGIT}+"."{DIGIT}+"."{DIGIT}+"."{DIGIT}+ {
	GyyLine = yyline;
	return E_IP;
}
<INITIAL> {DIGIT}+"."{DIGIT}+ {
	GyyLine = yyline;
	return E_FLOAT;
}
<INITIAL> {VAR} {
	GyyLine = yyline;
	return E_VAR;
}
<INITIAL,COMMENT> . {
        System.Console.WriteLine("Illegal character: <" + yytext + "> at line #" + yyline);
	Utility.error(yyline,Utility.E_UNMATCHED);
	break;
}

%%
/* bool comment_sharp = false; */
int comment_count = 0;
int bloc_count = 0;
public string strBloc = "";
public int GyyLine = 0;
/*
class Sample {
    public static void Main(string[] argv)  {
        try
        {
            int tok;
            FileStream file = new FileStream("LFSLapper.cfg", FileMode.Open);
            Scanner scnr = new Scanner(file);
             do {
                 tok = scnr.yylex();
                 Console.WriteLine("#"+tok + ": " + scnr.yytext);
             } while (tok > (int)Tokens.EOF);
        }
        catch (System.Exception e)
        {
            Console.WriteLine(e.Message);
        }
                Console.ReadKey();
    }

}
*/
public const int E_END = 0;
public const int E_DOUBLEDOT = 1;
public const int E_SEMICOLON = 2;
public const int E_PAR_OPEN = 3;
public const int E_PAR_CLOSE = 4;
public const int E_BRACKET_OPEN = 5;
public const int E_BRACKET_CLOSE = 6;
public const int E_POINT = 9;
public const int E_PLUS = 10;
public const int E_MOINS = 11;
public const int E_MULT = 12;
public const int E_DIV = 13;
public const int E_EQUAL = 14;
public const int E_DIFF = 15;
public const int E_LESS = 16;
public const int E_LESS_EQUAL = 17;
public const int E_MORE = 18;
public const int E_MORE_EQUAL = 19;
public const int E_AND = 20;
public const int E_OR = 21;
public const int E_POW = 22;
public const int E_COLON = 24;
public const int E_INTEGER = 50;
public const int E_STRING = 40;
public const int E_ASSIGN = 42;
public const int E_IDENT = 43;
public const int E_IP = 45;
public const int E_FLOAT = 46;
public const int E_VAR = 47;
public const int E_BLOC = 48;
public const int E_BEGIN_FUNCTION = 100;
public const int E_END_FUNCTION = 101;
public const int E_IF = 102;
public const int E_THEN = 103;
public const int E_ELSE = 104;
public const int E_ENDIF = 105;
public const int E_GLOBALVAR = 106;
public const int E_PLAYERVAR = 107;
public const int E_WHILE = 108;
public const int E_ENDWHILE = 109;
public const int E_FOR = 110;
public const int E_ENDFOR = 111;
public const int E_BREAK = 112;
public const int E_SWITCH = 113;
public const int E_ENDSWITCH = 114;
public const int E_CASE = 115;
public const int E_DEFAULT = 116;
public const int E_BOOL_AND = 117;
public const int E_BOOL_OR = 118;
public const int E_LANG = 119;
public const int E_ENDLANG = 120;
class Utility {
  public static void assert( bool expr, string errMsg )
  {
		if (false == expr) {
		  throw (new System.Exception("Error: " + errMsg));
		}
  }

  private static readonly string[] errorMsg =new string[] {
    "Error: Unmatched end-of-comment punctuation.",
    "Error: Unmatched start-of-comment punctuation.",
    "Error: Unclosed string.",
    "Error: Illegal character."
    };

  public const int E_ENDCOMMENT = 0;
  public const int E_STARTCOMMENT = 1;
  public const int E_UNCLOSEDSTR = 2;
  public const int E_UNMATCHED = 3;
  

  public static void error(int yy,int code)
      {
	System.Console.WriteLine(errorMsg[code] + " at line #" + yy);
      }
}


