/*
    LFSLapper, Insim Race and qualification Manager for Live For Speed Game
    Copyright (C) 2007  Robert B. alias Gai-Luron and Monkster: lfsgailuron@free.fr

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
using System;
using System.Text;
using System.Data;
using Mono.Data.SqliteClient;
using System.Runtime.Remoting.Contexts;


namespace LFSDbs
{
    public class DbsAccess
    {
        public IDbConnection dbCon;
        public IDbCommand dbSql;
        private GLDebug.Debug myDebug;

        static System.Collections.Hashtable toto = new System.Collections.Hashtable();

            public DbsAccess( GLDebug.Debug pmyDebug, string DbName ){
                
//                IDbConnection pdbCon;
                this.myDebug = pmyDebug;

                if (!System.IO.File.Exists(DbName + ".dbs"))
                {
                    myDebug.WriteLine("mss","Dbs not exist, Creation of : " + DbName + ".dbs");
                }
                dbCon = (IDbConnection)new SqliteConnection("URI=file:" + DbName + ".dbs" + ",version=3");
                dbCon.Open();
                dbSql = dbCon.CreateCommand();

            }

            public bool isExistTable(string tableName)
            {
                

//                dbSql.CommandText = "SELECT name FROM SQLITE_MASTER WHERE type = 'table' AND name = '" + tableName + "'";
//                IDataReader reader = dbSql.ExecuteReader();
                IDataReader reader = executeQuery("SELECT name FROM SQLITE_MASTER WHERE type = 'table' AND name = '" + tableName + "'" );
                if (reader.Read())
                    return true;

                return false;
            }
            public bool isExistColum(string tableName, string colName)
            {
                //If a Try here and not for other... maybe will have to test it out...
                dbSql.CommandText = "SELECT " + colName + " FROM " + tableName + " LIMIT 1";
                try
                {
                    IDataReader reader = dbSql.ExecuteReader();
                    reader.Read();
                }
                catch
                {
                    return false;
                };
                return true;
            }
            public bool isExistIndex(string indexName)
            {

                dbSql.CommandText = "SELECT name FROM sqlite_master WHERE type = 'index' AND name = '" + indexName + "'";
                IDataReader reader = dbSql.ExecuteReader();
                if (reader.Read())
                    return true;

                return false;
            }
            public uint getLastRowId(string _tableName)
            {
                IDataReader result = executeQuery("SELECT MAX( rowid ) FROM `" + _tableName + "`");
                //            IDataReader result = ExecuteQuery("SELECT MAX(`guid`) FROM `" + _tableName + "`");
                if (result.Read())
                    return (uint)result.GetInt32(0);

                return 0;
            }
        public IDataReader executeQuery(string _command)
        {
            return executeQuery2(_command);
        }
        private IDataReader executeQuery2(string _command)
        {
            DateTime timeOut = DateTime.Now.AddSeconds((double)20);
            System.Random rnd = new System.Random(DateTime.Now.Millisecond);

            IDataReader ir = null;
            while (true)
            {
                try
                {
                    dbSql.CommandText = _command;
                    ir = dbSql.ExecuteReader();
                    break;
                }

                catch (SqliteBusyException e)
                {
                    if (DateTime.Now > timeOut)
                    {
                        myDebug.WriteLine("err","Database Busy SQL COMMAND : ");
                        myDebug.printDateOnEachLine = false;
                        myDebug.WriteLine("err", _command);
                        myDebug.printDateOnEachLine = true;
                        throw e;
                    }
                    System.Threading.Thread.Sleep( rnd.Next(80, 300) );
                }
                catch( Exception e )
                {
                    if (DateTime.Now > timeOut || e.Message != "database is locked")
                    {

                        myDebug.WriteLine("err","SQL COMMAND : ");
                        myDebug.printDateOnEachLine = false;
                        myDebug.WriteLine("err", _command);
                        myDebug.WriteLine("err","");
                        myDebug.printDateOnEachLine = true;
                        throw e;
                    }
//                    Console.WriteLine("Database Busy Retry " + i++);
                    System.Threading.Thread.Sleep(rnd.Next(80, 300));
                }

            }
            return ir;
        }
        public long executeNonQuery(string _command)
        {
/*
            if (_command == "BEGIN TRANSACTION" || _command == "COMMIT TRANSACTION")
                Console.WriteLine(_command);
*/
            return executeNonQuery2(_command);
        }
        public long executeNonQuery2(string _command)
        {

                DateTime timeOut = DateTime.Now.AddSeconds((double)20);
                System.Random rnd = new System.Random(DateTime.Now.Millisecond);

                int i=0;
                while (true)
                {

                    try
                    {
                        dbSql.CommandText = _command;
                        i = dbSql.ExecuteNonQuery();
                        break;
                    }
                    catch (SqliteBusyException e)
                    {
                        if (DateTime.Now > timeOut)
                        {
                            myDebug.WriteLine("err","Database Busy SQL COMMAND : ");
                            myDebug.printDateOnEachLine = false;
                            myDebug.WriteLine("err",_command);
                            myDebug.WriteLine("err","");
                            myDebug.printDateOnEachLine = true;
                            throw e;
                        }
//                        Console.WriteLine("Database Busy Retry ");
                        System.Threading.Thread.Sleep( rnd.Next(80,300) );
                    }
                    catch (Exception e)
                    {
                        myDebug.WriteLine("err", "SQL COMMAND : ");
                        myDebug.printDateOnEachLine = false;
                        myDebug.WriteLine("err", _command);
                        myDebug.WriteLine("err","");
                        myDebug.printDateOnEachLine = true;
                        throw e;
                    }
                }
                return i;
            }
     }

}
