// dllmain.cpp : Defines the entry point for the DLL application.
#include "stdafx.h"
#include "myIDirect3D8.h"
#include "myIDirect3DDevice8.h"

myIDirect3DDevice8* gl_pmyIDirect3DDevice8;
myIDirect3D8*       gl_pmyIDirect3D8;
HINSTANCE           gl_hOriginalDll;
HINSTANCE           gl_hThisInstance;

#pragma data_seg(".DG_SHAREDATA")

BOOL				sd_SpeedVisible			= true;
int					sd_Speed				= 0;
float				sd_SpeedX				= 0.0F;
float				sd_SpeedY				= 0.0F;
float				sd_SpeedSize			= 0.0F;

BOOL				sd_GearVisible			= false;
int					sd_Gear					= 1;    //neutral
float				sd_GearX				= 0.0F;
float				sd_GearY				= 0.0F;
float				sd_GearSize				= 0.0F;

BOOL				sd_LedVisible			= false;
int					sd_Led					= 0; 
float				sd_LedX					= 0.0F;
float				sd_LedY					= 0.0F;
float				sd_LedSize				= 0.0F;

BOOL				sd_RpmVisible			= false;
int					sd_Rpm					= 0; 
float				sd_RpmX					= 0.0F;
float				sd_RpmY					= 0.0F;
float				sd_RpmSize				= 0.0F;

D3DCOLOR			sd_DigitsColor			= D3DCOLOR_ARGB(0xff, 0xff, 0xff, 0xff);
HWND				sd_Hwnd					= NULL;
char				sd_FilePath[MAX_PATH]	= { '\0' };


#pragma data_seg()

#pragma comment(linker, "/SECTION:.DG_SHAREDATA,RWS")

void InitInstance(HANDLE hModule);
void ExitInstance(void);
void LoadOriginalDll(void);

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH: 
		InitInstance(hModule); 
		break;
	case DLL_PROCESS_DETACH: 
		ExitInstance(); 
		break;
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
		break;
	}
	return TRUE;
}


void InitInstance(HANDLE hModule) 
{
	OutputDebugString("PROXYDLL: InitInstance called.\r\n");
	
	// Initialisation
	gl_hOriginalDll        = NULL;
	gl_hThisInstance       = NULL;
	gl_pmyIDirect3D8       = NULL;
	gl_pmyIDirect3DDevice8 = NULL;	
		
	// Storing Instance handle into global var
	gl_hThisInstance = (HINSTANCE)  hModule;
}

void ExitInstance() 
{    
    OutputDebugString("PROXYDLL: ExitInstance called.\r\n");
		
	// Release the system's d3d8.dll
	if (gl_hOriginalDll)
	{
		::FreeLibrary(gl_hOriginalDll);
	    gl_hOriginalDll = NULL;  
	}

	//send to DS exit cmd
	if (sd_Hwnd != NULL)
	{
		GetModuleFileName(NULL, sd_FilePath, MAX_PATH);
		PostMessage(sd_Hwnd, WM_LFS_EXIT, 0, 0); 
	}
}

void LoadOriginalDll(void)
{	 
    char buffer[MAX_PATH];
    
    // Getting path to system dir and to d3d8.dll
	::GetSystemDirectory(buffer,MAX_PATH);

	// Append dll name
	strcat_s(buffer,"\\d3d8.dll");
	
	// try to load the system's d3d8.dll, if pointer empty
	if (!gl_hOriginalDll) gl_hOriginalDll = ::LoadLibrary(buffer);

	// Debug
	if (!gl_hOriginalDll)
	{
		OutputDebugString("PROXYDLL: Original d3d8.dll not loaded ERROR ****\r\n");
		::ExitProcess(0); // exit the hard way
	}
}

/*****************			EXPORTS	           *********************/

IDirect3D8* WINAPI Direct3DCreate8(UINT SDKVersion)
{
	if (!gl_hOriginalDll) LoadOriginalDll(); // looking for the "right d3d8.dll"
	
	// Hooking IDirect3D Object from Original Library
	typedef IDirect3D8 *(WINAPI* D3D8_Type)(UINT SDKVersion);
	D3D8_Type D3DCreate8_fn = (D3D8_Type) GetProcAddress( gl_hOriginalDll, "Direct3DCreate8");
    
    // Debug
	if (!D3DCreate8_fn) 
    {
        OutputDebugString("PROXYDLL: Pointer to original D3DCreate8 function not received ERROR ****\r\n");
        ::ExitProcess(0); // exit the hard way
    }
	
	// Request pointer from Original Dll. 
	IDirect3D8 *pIDirect3D8_orig = D3DCreate8_fn(SDKVersion);
	
	// Create my IDirect3D8 object and store pointer to original object there.
	// note: the object will delete itself once Ref count is zero (similar to COM objects)
	gl_pmyIDirect3D8 = new myIDirect3D8(pIDirect3D8_orig);
	
	// Return pointer to hooking Object instead of "real one"
	return (gl_pmyIDirect3D8);
}

void WINAPI SetSpeedVisible(BOOL val)
{
	sd_SpeedVisible = val;
}

void WINAPI SetSpeed(int val)
{
	val = (val < 0) ? 0 : val;
	val = (val > 999) ? 999 : val;

	sd_Speed = val;
}

void WINAPI SetSpeedPosSize(int x, int y, int s)
{
	x = (x < 0) ? 0 : x;
	x = (x > 1000) ? 1000 : x;

	sd_SpeedX = (float)x;
	
	y = (y < 0) ? 0 : y;
	y = (y > 1000) ? 1000 : y;

	sd_SpeedY = (float)y;

	s = (s < 0) ? 0 : s;
	s = (s > 100) ? 100 : s;

	sd_SpeedSize = (float)(s * 0.725);
}

void WINAPI SetGearVisible(BOOL val)
{
	sd_GearVisible = val;
}

void WINAPI SetGear(int val)
{
	val = (val < 0) ? 0 : val;
	val = (val > 10) ? 10 : val;

	sd_Gear = val;
}

void WINAPI SetGearPosSize(int x, int y, int s)
{
	x = (x < 0) ? 0 : x;
	x = (x > 1000) ? 1000 : x;

	sd_GearX = (float)x;
	
	y = (y < 0) ? 0 : y;
	y = (y > 1000) ? 1000 : y;

	sd_GearY = (float)y;

	s = (s < 0) ? 0 : s;
	s = (s > 100) ? 100 : s;

	sd_GearSize = (float)(s * 0.725);
}

void WINAPI SetLedVisible(BOOL val)
{
	sd_LedVisible = val;
}

void WINAPI SetLed(int val)
{
	val = (val < 0) ? 0 : val;
	val = (val > 3) ? 3 : val;

	sd_Led = val;
}

void WINAPI SetLedPosSize(int x, int y, int s)
{
	x = (x < 0) ? 0 : x;
	x = (x > 1000) ? 1000 : x;

	sd_LedX = (float)x;
	
	y = (y < 0) ? 0 : y;
	y = (y > 1000) ? 1000 : y;

	sd_LedY = (float)y;

	s = (s < 0) ? 0 : s;
	s = (s > 100) ? 100 : s;

	sd_LedSize = (float)(s * 0.4);
}

void WINAPI SetRpmVisible(BOOL val)
{
	sd_RpmVisible = val;
}

void WINAPI SetRpm(int val)
{
	val = (val < 0) ? 0 : val;
	val = (val > 99999) ? 99999 : val;

	sd_Rpm = val;
}

void WINAPI SetRpmPosSize(int x, int y, int s)
{
	x = (x < 0) ? 0 : x;
	x = (x > 1000) ? 1000 : x;

	sd_RpmX = (float)x;
	
	y = (y < 0) ? 0 : y;
	y = (y > 1000) ? 1000 : y;

	sd_RpmY = (float)y;

	s = (s < 0) ? 0 : s;
	s = (s > 100) ? 100 : s;

	sd_RpmSize = (float)(s * 0.725);
}

void WINAPI SetDigitsColor(int r, int g, int b)
{
	sd_DigitsColor = D3DCOLOR_ARGB(0xff, r, g, b);
}

void WINAPI ResetOG()
{
	sd_SpeedVisible			= false;
	sd_Speed				= 0;
	sd_SpeedX				= 0.0F;
	sd_SpeedY				= 0.0F;
	sd_SpeedSize			= 0.0F;
	
	sd_GearVisible			= false;
	sd_Gear					= 1;
	sd_GearX				= 0.0F;
	sd_GearY				= 0.0F;
	sd_GearSize				= 0.0F;

	sd_LedVisible			= false;	
	sd_Led					= 0;
	sd_LedX					= 0.0F;
	sd_LedY					= 0.0F;
	sd_LedSize				= 0.0F;

	sd_RpmVisible			= false;	
	sd_Rpm					= 0;
	sd_RpmX					= 0.0F;
	sd_RpmY					= 0.0F;
	sd_RpmSize				= 0.0F;
	sd_DigitsColor			= D3DCOLOR_ARGB(0xff, 0xff, 0xff, 0xff);
}

void WINAPI SetHwnd(HWND hwnd)
{
	sd_Hwnd	= hwnd;
}

void WINAPI GetFilePath(char& filePath)
{
	//memcpy(&sd_FilePath, "dupa", 4);
	memcpy(&filePath, sd_FilePath, strlen(sd_FilePath) + 1);
}

	