#pragma once

#include <D3dx8core.h>

class CDigitalGauges
{
public:

	CDigitalGauges(IDirect3DDevice8 *pD3DDevice);
	virtual ~CDigitalGauges();

	void					Render(void);
	void					OnLostDevice(void);
	void					OnResetDevice(void);

private:
	IDirect3DDevice8*		m_pD3DDevice;
	ID3DXSprite*			m_pBackgroundSprite;
	IDirect3DTexture8*		m_pBackgroundTexture;
	double					m_LedBlinkTimeFast;
	//double					m_LedBlinkTimeSlow;
	BOOL					m_LedBlinkFast;
	//BOOL					m_LedBlinkSlow;
	void					DrawSpeed(float posDestX, float posDestY, float size);
	void					DrawGear(float posDestX, float posDestY, float size);
	void					DrawDigit(int digit, int index, float posDestX, float posDestY, float size);
	void					DrawLed(float posDestX, float posDestY, float size);
	void					DrawRpm(float posDestX, float posDestY, float size);

	enum 
    {
		Led_Off         = 0,
        Led_ShiftLight  = 1,
        Led_Redline     = 2,
        Led_OilWarn     = 3
    };
};

