#include "stdafx.h"
#include "DigitalGauges.h"
#include <stdio.h>
#include <time.h>

#define BITMAP_W		210 
#define BITMAP_H		210 
#define DIGIT_W			39
#define DIGIT_H			50
#define LED_W			50
#define LED_H			50
#define DIGIT_SPACE		1;

extern HINSTANCE		gl_hThisInstance;

extern BOOL				sd_SpeedVisible;	
extern int				sd_Speed;	
extern float			sd_SpeedX;
extern float			sd_SpeedY;
extern float			sd_SpeedSize;

extern BOOL				sd_GearVisible;	
extern int				sd_Gear;	
extern float			sd_GearX;
extern float			sd_GearY;
extern float			sd_GearSize;

extern BOOL				sd_LedVisible;
extern int				sd_Led;
extern float			sd_LedX;
extern float			sd_LedY;
extern float			sd_LedSize;

extern BOOL				sd_RpmVisible;
extern int				sd_Rpm;
extern float			sd_RpmX;
extern float			sd_RpmY;
extern float			sd_RpmSize;
extern D3DCOLOR			sd_DigitsColor;

CDigitalGauges::CDigitalGauges(IDirect3DDevice8 *pD3DDevice)
{
	m_pD3DDevice			= pD3DDevice;

	m_LedBlinkFast			= false;
	//m_LedBlinkSlow			= false;
	m_LedBlinkTimeFast		= 0;
	//m_LedBlinkTimeSlow		= 0;
	m_pBackgroundSprite		= NULL;
	m_pBackgroundTexture	= NULL;

	D3DXCreateSprite(m_pD3DDevice,&m_pBackgroundSprite);
	D3DXCreateTextureFromResourceEx(m_pD3DDevice, gl_hThisInstance, MAKEINTRESOURCE(1), BITMAP_W, BITMAP_H, 0, NULL, D3DFMT_UNKNOWN, D3DPOOL_MANAGED, D3DX_FILTER_NONE, D3DX_FILTER_NONE, 0xFF000000, NULL, NULL, &m_pBackgroundTexture);
	
	//D3DXCreateTextureFromFile(m_pD3DDevice, "digits.png", &m_pBackgroundTexture);
}

CDigitalGauges::~CDigitalGauges()
{
	if (m_pBackgroundSprite) 
		m_pBackgroundSprite->Release();
	if (m_pBackgroundTexture) 
		m_pBackgroundTexture->Release();   
}

void CDigitalGauges::Render(void)
{
	m_pD3DDevice->BeginScene();

	D3DVIEWPORT8 vp;
	m_pD3DDevice->GetViewport(&vp);
	
	float aspect	= (float)(vp.Width / vp.Height);
	float offset	= 0;
	if (aspect >= 3)
	{
		vp.Width   /= 3;
		offset		= (float)vp.Width;
	}
	
	float speedSize = (float)(vp.Width * sd_SpeedSize / 1000 / DIGIT_H);
	float speedX	= (float)((vp.Width - (3 * DIGIT_W * speedSize)) * sd_SpeedX / 1000) + offset;
	float speedY	= (float)((vp.Height - (DIGIT_H * speedSize)) * sd_SpeedY / 1000);
	
	float gearSize	= (float)(vp.Width * sd_GearSize / 1000 / DIGIT_H);
	float gearX		= (float)((vp.Width - (DIGIT_W * gearSize)) * sd_GearX / 1000) + offset;
	float gearY		= (float)((vp.Height - (DIGIT_H * gearSize)) * sd_GearY / 1000);
	
	float ledSize	= (float)(vp.Width * sd_LedSize / 1000 / LED_H);
	float ledX		= (float)((vp.Width - (LED_W * ledSize)) * sd_LedX / 1000) + offset;
	float ledY		= (float)((vp.Height - (LED_H * ledSize)) * sd_LedY / 1000);

	float rpmSize	= (float)(vp.Width * sd_RpmSize / 1000 / DIGIT_H);
	float rpmX		= (float)((vp.Width - (5 * DIGIT_W * rpmSize)) * sd_RpmX / 1000) + offset;
	float rpmY		= (float)((vp.Height - (DIGIT_H * rpmSize)) * sd_RpmY / 1000);
	
	m_pBackgroundSprite->Begin();

	DrawSpeed(speedX, speedY, speedSize);
	DrawRpm(rpmX, rpmY, rpmSize);
	DrawGear(gearX, gearY, gearSize);
	DrawLed(ledX, ledY, ledSize);

	m_pBackgroundSprite->End();
	m_pD3DDevice->EndScene();
}

void CDigitalGauges::OnLostDevice(void)
{
	m_pBackgroundSprite->OnLostDevice();
}

void CDigitalGauges::OnResetDevice(void)
{
	m_pBackgroundSprite->OnResetDevice();
}

void CDigitalGauges::DrawSpeed(float posDestX, float posDestY, float size)
{
	if (!sd_SpeedVisible)
		return;

	if (sd_Speed > 99)
		DrawDigit((sd_Speed/100)%10, 0, posDestX, posDestY, size);
	
	if (sd_Speed > 9)
		DrawDigit((sd_Speed/10)%10, 1, posDestX, posDestY, size);
	
	DrawDigit(sd_Speed%10, 2, posDestX, posDestY, size);
}

void CDigitalGauges::DrawGear(float posDestX, float posDestY, float size)
{
	if (!sd_GearVisible)
		return;

	int gear = sd_Gear;
	if (gear < 2)
		gear += 10;
	else
		gear--;

	DrawDigit(gear, 0, posDestX, posDestY, size);
}

void CDigitalGauges::DrawDigit(int digit, int index, float posDestX, float posDestY, float size)
{
	int posSrcX	= 0;
	int posSrcY	= 0;

	if (digit > 9)
	{
		digit	-= 10;
		posSrcY	+= 2 * DIGIT_H + 2;
	}
	else if (digit > 4)
	{
		digit	-= 5;
		posSrcY	+= DIGIT_H + 1;
	}

	posSrcX		= digit * DIGIT_W + digit;
	RECT rect	= {posSrcX, posSrcY, posSrcX + DIGIT_W, posSrcY + DIGIT_H};
	posDestX	+= index * DIGIT_W * size;
	
	D3DXMATRIX matrix(	size, 0, 0, 0,
						0, size, 0, 0, 
						0, 0, 1, 0,
						posDestX, posDestY, 0, 1);
	
	
	m_pBackgroundSprite->DrawTransform(m_pBackgroundTexture, &rect, &matrix, sd_DigitsColor);
}

void CDigitalGauges::DrawLed(float posDestX, float posDestY, float size)
{
	if (!sd_LedVisible || sd_Led == Led_Off)
		return;

	D3DCOLOR col;

	double tc = GetTickCount();
	if (tc - m_LedBlinkTimeFast > 40)
	{
		m_LedBlinkTimeFast	= tc;
		m_LedBlinkFast		= !m_LedBlinkFast;
	}
	//if (tc - m_LedBlinkTimeSlow > 100)
	//{
	//	m_LedBlinkTimeSlow	= tc;
	//	m_LedBlinkSlow		= !m_LedBlinkSlow;
	//}

	int posSrcX	= 0;
	int posSrcY	= 3 * DIGIT_H + 3;

	if (sd_Led == Led_OilWarn)
		posSrcX	= 0;//(LED_W + 1) * m_LedBlinkSlow;
	else
		posSrcX	= (LED_W + 1) * m_LedBlinkFast;

	if (sd_Led == Led_Redline)// || sd_Led == Led_OilWarn)
		col	= D3DCOLOR_ARGB(0xFF,0xFF,0x66,0x00);
	else
		col = D3DCOLOR_ARGB(0xFF,0xEE,0x00,0x00);		

	RECT rect	= {posSrcX, posSrcY, posSrcX + LED_W, posSrcY + LED_H};	
	D3DXMATRIX matrix(	size, 0, 0, 0,
						0, size, 0, 0, 
						0, 0, 1, 0,
						posDestX, posDestY, 0, 1);
	
	m_pBackgroundSprite->DrawTransform(m_pBackgroundTexture, &rect, &matrix, col);
}

void CDigitalGauges::DrawRpm(float posDestX, float posDestY, float size)
{
	if (!sd_RpmVisible)
		return;

	if (sd_Rpm > 9999)
		DrawDigit((sd_Rpm/10000)%10, 0, posDestX, posDestY, size);
	
	if (sd_Rpm > 999)
		DrawDigit((sd_Rpm/1000)%10, 1, posDestX, posDestY, size);
	
	if (sd_Rpm > 99)
		DrawDigit((sd_Rpm/100)%10, 2, posDestX, posDestY, size);
	
	if (sd_Rpm > 9)
		DrawDigit((sd_Rpm/10)%10, 3, posDestX, posDestY, size);
	
	DrawDigit(sd_Rpm%10, 4, posDestX, posDestY, size);
}

