using System;
using System.Xml;
using System.IO;
using System.Text;
using System.Xml.XPath;
using System.Collections;

namespace Tools
{
	public class XmlConfig
	{
		private XmlDocument xml; 
		private string  fileName;
        private string rootNode                 = "settings";
        private XPathNodeIterator readIterator  = null;

		public XmlConfig(string path)
		{
            string[] s  = path.Split('.');
            string ext  = s[s.Length - 1];
            fileName    = path.Replace(ext, "cfg");
		}

		public void Write(string section, string value)
		{
			try
			{
				if (xml == null)
				{
					xml = new XmlDocument();
                    XmlNode root = this.xml.CreateElement(rootNode);
					xml.AppendChild(root);
				}

                XmlNode sectionNode = xml.SelectSingleNode(("/" + rootNode + "/" + section));
				if (sectionNode == null)
				{
					sectionNode = xml.CreateElement(section);
					XmlNode root = xml.SelectSingleNode("/" + rootNode);
					root.AppendChild(sectionNode);
				}

				sectionNode.InnerText = value;
			}
			catch{}
		}

		public int ReadInt(string section, int defVal)
		{
			string val = Read(section);

			if (val.Length <= 0)
				return defVal;

			try
			{
				int value = Convert.ToInt32(val);
				return value;
			}
			catch
			{
				return defVal;
			}
		}

		public string ReadString(string section, string defVal)
		{
			string val = Read(section);

			if (val.Length <= 0)
				return defVal;

			return val;
		}

		private string Read(string section)
		{
			if (xml == null)
				return String.Empty;
			
			try
			{
                XmlNode sectionNode = this.xml.SelectSingleNode(("/" + rootNode + "/" + section));
				if (sectionNode == null)
					return String.Empty;				
                if (sectionNode.FirstChild == null)
                    return String.Empty;

				return sectionNode.FirstChild.Value;
			}
			catch
			{
				return String.Empty;
			}
		}

		public void Load()
		{
			XmlTextReader r	= new XmlTextReader(fileName);

			try
			{
				if (xml == null)
					xml = new XmlDocument();

				xml.Load(r);
			}
			catch(Exception ex)
			{
				xml = null;
				Console.WriteLine(ex.Message);
			}
			finally
			{
				r.Close();
			}
		}

		public void Save()
		{
			XmlTextWriter w	= new XmlTextWriter(fileName, Encoding.UTF8);
			w.Formatting	= Formatting.Indented;

			try
			{	
				xml.Save(w);
			}	
			catch
			{
			}
			finally
			{
				w.Close();
			}
		}

        public void WriteMultiple(string section, string id, SortedList sl)
		{
			if (sl == null)
                return;

			try
			{
				if (xml == null)
				{
					xml = new XmlDocument();
                    XmlNode root = this.xml.CreateElement(rootNode);
					xml.AppendChild(root);
				}

				XmlNode oldCfg;
				XmlElement doc = xml.DocumentElement;
				                
				//IDictionaryEnumerator f = sl.GetEnumerator();
				//f.MoveNext();
                //oldCfg = doc.SelectSingleNode("/" + rootNode + "/" + section + "[" + f.Key + "='" + f.Value + "']");
                oldCfg = doc.SelectSingleNode("descendant::" + section + "[@id='" + id + "']");
                				
				XmlElement newCfg = xml.CreateElement(section);
				newCfg.InnerXml = String.Empty;
                newCfg.SetAttribute("id", id);
				foreach(DictionaryEntry de in sl)
					newCfg.InnerXml += "<" + de.Key + ">" + de.Value + "</" + de.Key + ">";

				if (oldCfg == null)
                    doc.AppendChild(newCfg);
				else
                    doc.ReplaceChild(newCfg, oldCfg);
			}
			catch(Exception ex)
			{
				Console.WriteLine(ex.Message);
			}
		}

		public ArrayList ReadMultiple(string section, ArrayList keys)
		{
			if (xml == null)
				return null;

			ArrayList result = new ArrayList();

			try
			{
				XPathNavigator nav		= xml.CreateNavigator();
				XPathNodeIterator itr   = nav.Select(rootNode + "/" + section);
            	
				while (itr.MoveNext())
				{
					SortedList sl	= new SortedList();
					foreach(string s in keys)
					{
						XPathNodeIterator nitr = itr.Current.Select(s);
						if (!nitr.MoveNext())
							continue;
						
						sl.Add(s, nitr.Current.Value);
					}

					result.Add(sl);
				}
			}
			catch(Exception ex)
			{
				Console.WriteLine(ex.Message);
			}
			
			return result;
		}

		public SortedList ReadMultiple(string section, ref string id)
		{
			if (xml == null)
				return null;

			try
			{
                if (readIterator == null)
                {
				    XPathNavigator nav	= xml.CreateNavigator();
				    readIterator        = nav.Select(rootNode + "/" + section);
                }
            	                
				if (readIterator.MoveNext())
				{
                    id              = readIterator.Current.GetAttribute("id", string.Empty);
					SortedList sl	= new SortedList();
                    
                    XPathNodeIterator nitr = readIterator.Current.SelectChildren(XPathNodeType.All);
                    while (nitr.MoveNext())
                        sl.Add(nitr.Current.LocalName, nitr.Current.Value);
                    
                    return sl;					
				}
                
                readIterator = null;
			}
			catch(Exception ex)
			{
				Console.WriteLine(ex.Message);
			}
			
			return null;
		}
	}
}
