using System;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.Collections;

namespace Tools
{
	public class DataConverter
	{
		public static byte[] PacketToData(object SourceStruct)
	    {
	        int size	= Marshal.SizeOf(SourceStruct);             // Size of source structure
	        IntPtr ptr 	= Marshal.AllocHGlobal(size);             // Memory pointer to copy data to
	        byte[] data = new byte[size];                        // Size of new aray
	        
	        GCHandle pin = GCHandle.Alloc(ptr);
	        Marshal.StructureToPtr(SourceStruct, ptr, false);   // Copy struct to pointer
	        Marshal.Copy(ptr, data, 0, size);                    // Copy pointer to byte array
	        pin.Free();
	        Marshal.FreeHGlobal(ptr);                           // Free pointer
	        
	        return data;                                        // Return byte array
	    }
	}
	
    public class PacketsCounter
    {
        private int time;
        private int packetsPerSecond;
        private int packetsCount;
        
        public PacketsCounter()
        {
            time                = 0;
            packetsCount        = 0;
            packetsPerSecond    = 0;
        }

        public void Increment()
        {
            if (time != DateTime.Now.Second)
			{
				time	            = DateTime.Now.Second;
				packetsPerSecond 	= packetsCount;
				packetsCount 	    = 0;
			}
			packetsCount++;
        }

        public int PacketsPerSecond
        {
            get
            {
                return packetsPerSecond;
            }
        }
    }
	
    public class ButtonIds
	{
		private ArrayList items = new ArrayList();
		private byte offset     = 0;
        private byte max        = 240;

        public ButtonIds(byte startIndex)
        {
            offset = startIndex;
        }

		public void Clear()
		{
			items.Clear();
		}
		
		public byte Add()
		{          
            int index = items.IndexOf(false);
			
			if (index == -1)
				index = items.Add(true);
			else
				items[index] = true;

            if (index + offset > max)
                throw new Exception("BtnIds: index out of range (240 max)");
			
			return (byte)(index + offset);
		}
		
		public void RemoveAt(int index)
		{
			items[index - offset] = false;
		}
	}
}
