using System;
using System.Collections;
using System.Text;
using System.Drawing;
using Tools;
using System.Windows.Forms;
using System.IO;

namespace LFS
{
    class Pitlane
    {
        private XmlConfig cfg;
        private Polygon pitlane;  
        private string currTrack    = string.Empty;

        public Pitlane()
        {
            string fp   = Path.GetDirectoryName(Application.ExecutablePath);
            fp         += "\\pitlane.cfg";

            cfg = new XmlConfig(fp);
            cfg.Load();
        }

        public void Load(string track)
        {
            if (currTrack == track)
                return;

            if (pitlane != null)
                pitlane.Reset();

            currTrack   = track;
            int idx     = currTrack.IndexOf('\0');
            string trk  = currTrack.ToLower().Remove(idx, currTrack.Length - idx);
            trk         = (trk[trk.Length - 1] == 'r') ? trk.Remove(trk.Length - 1, 1) : trk;
            string crd  = cfg.ReadString("tracks/" + trk, string.Empty);
            if (crd == string.Empty)
                return;

            string pts  = cfg.ReadString("coordinates/" + crd, string.Empty);
            if (pts == string.Empty)
                return;            

            try
            {
                ArrayList points = new ArrayList();            
                string[] spts = pts.Split(';');
                foreach (string spt in spts)
                {
                    if (spt.Length == 0)
                        continue;

                    string[] pt = spt.Split(',');
                    if (pt.Length != 2)
                        throw new Exception("Polygon create: invalid data");

                    points.Add(new PointF(float.Parse(pt[0].Replace('.', ',')), float.Parse(pt[1].Replace('.', ','))));
                }

                pitlane = new Polygon(points);                    
            }
            catch(Exception ex)
            {
                Log.Error(ex.ToString());
            }
        }

        public bool Contains(float x, float y)
        {            
            if (pitlane == null)
                return false;

            return pitlane.Contains(new PointF(x, y));            
        }
    }

    class Polygon
    {
        private ArrayList   polygon;
        private RectangleF  bounds;
        
        public Polygon(ArrayList points)
        {
            float minX, minY, maxX, maxY;

            polygon = points;
            minX    = maxX = ((PointF)polygon[0]).X;
            minY    = maxY = ((PointF)polygon[0]).Y;            

            foreach(PointF pt in polygon)
            {
                minX = (pt.X < minX) ? pt.X : minX;
                minY = (pt.Y < minY) ? pt.Y : minY;
                maxX = (pt.X > maxX) ? pt.X : maxX;
                maxY = (pt.Y > maxY) ? pt.Y : maxY;
            }

            bounds = new RectangleF(minX, minY, maxX - minX, maxY - minY);
        }

        public bool Contains(PointF pt)
        {
            if (bounds.Contains(pt) == false)
                return false;

            bool pin    = false;
            int i, j    = 0;

            for (i = 0, j = polygon.Count - 1; i < polygon.Count; j = i++)
            {
                PointF pti = (PointF)polygon[i];
                PointF ptj = (PointF)polygon[j];

                if ((((pti.Y <= pt.Y) && (pt.Y < ptj.Y)) || ((ptj.Y <= pt.Y) && (pt.Y < pti.Y))) &&
                    (pt.X < (ptj.X - pti.X) * (pt.Y - pti.Y) / (ptj.Y - pti.Y) + pti.X))
                {
                    pin = !pin;
                }
            }

            return pin;
        }

        public void Reset()
        {
            polygon.Clear();
            bounds  = new RectangleF();        
        }
    }
}
