using System;
using System.Net.Sockets;
using System.Net;
using InSim.Enums;
using InSim.Structs;
using Tools;

namespace OutGauge
{
	public class OutGaugeReader
	{
		private byte[] 		data 		= new byte[512];
		private int			dataSize;
		private Socket		sock;
		private int		    recvPort;
		private bool		connected	= false;
		
		public  delegate void			OutGaugeDelegate(OutGaugePack packet);
		public  event OutGaugeDelegate	OutGaugeEvent;
				
		public OutGaugeReader(int port)
		{
			recvPort = port;
			
			try
			{	
				sock = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);
				IPEndPoint end = new IPEndPoint(IPAddress.Any, recvPort);
    			sock.Bind(end);
    			
    			StartReceive();
    			connected = true;
    			
    			Log.Trace("OutGaugeReader OK");
			}
			catch (Exception ex)
			{
				Log.Error(ex.ToString());
			}
		}
		
		public void Close()
		{
			try
			{
				connected = false;
				
				sock.Shutdown(SocketShutdown.Both);
				sock.Close();				
			}
			catch(Exception ex)
			{
				Log.Error(ex.ToString());
			}
		}
		
		private void StartReceive()
		{
			try
			{
    			sock.BeginReceive(data, 0, data.Length, SocketFlags.None, new AsyncCallback(ReceiveCallback), data);
			}
			catch(Exception ex)
			{
				Log.Error(ex.ToString());
			}
		}
		
		private void ReceiveCallback(IAsyncResult ar)
		{
			try
			{
				if (!connected)
					return;
				
				dataSize = sock.EndReceive(ar);
				
          		if (dataSize > 0)
    			{
    				HandlePacket();
        			StartReceive();
    			}
			}
			catch(SocketException ex)
			{
				Log.Error(ex.ToString());
			}
			catch(Exception ex)
			{
				Log.Error(ex.ToString());
			}
		}
		
		private void HandlePacket()
		{
			if (dataSize == 92 || dataSize == 96) //probably OG packet
			{
				OutGaugePack packet = new OutGaugePack(data);
				
				if (OutGaugeEvent != null)
					OutGaugeEvent(packet);
			}
			else
    			Log.Trace("unknown packet - {0} bytes", dataSize);
		}
		
		
		

	
	}

}
