using System;
//using System.Runtime.InteropServices;
//using System.Diagnostics;
//using System.Collections;
using System.Windows.Forms;
using System.IO;

namespace Tools
{	
	public class Log
	{
        private static StreamWriter logFile    = null;

		public static void Error(string format, params object[] arg)
		{
            string txt = DateTime.Now.ToString("HH:mm:ss - ") + String.Format(format, arg);

			Console.WriteLine(txt);
            
            if (logFile == null)
                CreateLogFile(Application.ExecutablePath);

            logFile.WriteLine(txt);
            logFile.WriteLine("---");
            logFile.Flush();
		}

        public static void Trace(string format, params object[] arg)
		{
            string txt = DateTime.Now.ToString("HH:mm:ss - ") + String.Format(format, arg);

			Console.WriteLine(txt);            
		}

        public static void Close()
        {
            if (logFile != null)
                logFile.Close();
        }

        private static void CreateLogFile(string path)
        {
            try
            {
                string[] s  = path.Split('.');
                string ext  = s[s.Length - 1];
                path        = path.Replace(ext, "log");
                
                bool append = true;
                if (File.Exists(path))
                {
                    FileInfo fi = new FileInfo(path);
                    append      = fi.Length < 1000000;
                }
                logFile     = new StreamWriter(path, append);
            }
            catch(Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }
	}
}
