using System;

namespace InSim.Enums
{
	public enum ISP : byte // the second byte in all packets is one of these
	{
		ISP_NONE		= 0,	//  				: not used
		ISP_ISI			= 1,	//  instruction		: insim initialise
		ISP_VER			= 2,	//  info			: version info
		ISP_TINY		= 3,	//  both ways		: multi purpose
		ISP_SMALL		= 4,	//  both ways		: multi purpose
		ISP_STA			= 5,	//  info			: state info
		ISP_SCH			= 6,	//  instruction		: single character
		ISP_SFP			= 7,	//  instruction		: state flags pack
		ISP_SCC			= 8,	//  instruction		: set car camera
		ISP_CPP			= 9,	//  both ways		: cam pos pack
		ISP_ISM			= 10,	//  info			: start multiplayer
		ISP_MSO			= 11,	//  info			: message out
		ISP_III			= 12,	//  info			: hidden /i message
		ISP_MST			= 13,	//  instruction		: type message or /command
		ISP_MTC			= 14,	//  instruction		: message to a connection
		ISP_MOD			= 15,	//  instruction		: set screen mode
		ISP_VTN			= 16,	//  info			: vote notification
		ISP_RST			= 17,	//  info			: race start
		ISP_NCN			= 18,	//  info			: new connection
		ISP_CNL			= 19,	//  info			: connection left
		ISP_CPR			= 20,	//  info			: connection renamed
		ISP_NPL			= 21,	//  info			: new player (joined race)
		ISP_PLP			= 22,	//  info			: player pit (keeps slot in race)
		ISP_PLL			= 23,	//  info			: player leave (spectate - loses slot)
		ISP_LAP			= 24,	//  info			: lap time
		ISP_SPX			= 25,	//  info			: split x time
		ISP_PIT			= 26,	//  info			: pit stop start
		ISP_PSF			= 27,	//  info			: pit stop finish
		ISP_PLA			= 28,	//  info			: pit lane enter / leave
		ISP_CCH			= 29,	//  info			: camera changed
		ISP_PEN			= 30,	//  info			: penalty given or cleared
		ISP_TOC			= 31,	//  info			: take over car
		ISP_FLG			= 32,	//  info			: flag (yellow or blue)
		ISP_PFL			= 33,	//  info			: player flags (help flags)
		ISP_FIN			= 34,	//  info			: finished race
		ISP_RES			= 35,	//  info			: result confirmed
		ISP_REO			= 36,	//  both ways		: reorder (info or instruction)
		ISP_NLP			= 37,	//  info			: node and lap packet
		ISP_MCI			= 38,	//  info			: multi car info
		ISP_MSX			= 39,	//  instruction		: type message
		ISP_MSL			= 40,	//  instruction		: message to local computer
		ISP_CRS			= 41,	//  info			: car reset
		ISP_BFN			= 42,	//  both ways		: delete buttons / receive button requests
		ISP_AXI			= 43,	//  info			: autocross layout information
		ISP_AXO			= 44,	//  info			: hit an autocross object
		ISP_BTN			= 45,	//  instruction		: show a button on local or remote screen
		ISP_BTC			= 46,	//  info			: sent when a user clicks a button
		ISP_BTT			= 47	//  info			: sent after typing into a button
	}
		
	public enum TINY : byte // the fourth byte of IS_TINY packets is one of these
	{
		TINY_NONE		= 0,	//  				: see "maintaining the connection"
		TINY_VER		= 1,	//  info request	: get version
		TINY_CLOSE		= 2,	//  instruction		: close insim
		TINY_PING		= 3,	//  ping request	: external progam requesting a reply
		TINY_REPLY		= 4,	//  ping reply		: reply to a ping request
		TINY_VTC		= 5,	//  info			: vote cancelled
		TINY_SCP		= 6,	//  info request	: send camera pos
		TINY_SST		= 7,	//  info request	: send state info
		TINY_GTH		= 8,	//  info request	: get time in hundredths (i.e. SMALL_RTP)
		TINY_MPE		= 9,	//  info			: multi player end
		TINY_ISM		= 10,	//  info request	: get multiplayer info (i.e. ISP_ISM)
		TINY_REN		= 11,	//  info			: race end (return to game setup screen)
		TINY_CLR		= 12,	//  info			: all players cleared from race
		TINY_NCN		= 13,	//  info			: get all connections
		TINY_NPL		= 14,	//  info			: get all players
		TINY_RES		= 15,	//  info			: get all results
		TINY_NLP		= 16,	//  info request	: send an IS_NLP
		TINY_MCI		= 17,	//  info request	: send an IS_MCI
		TINY_REO		= 18,	//  info request	: send an IS_REO
		TINY_RST		= 19,	//  info request	: send an IS_RST
		TINY_AXI		= 20,	//  info request	: send an IS_AXI
		TINY_AXC		= 21	//  info			: autocross cleared
	}

	public enum SMALL : byte // the fourth byte of IS_SMALL packets is one of these
	{
		SMALL_NONE		= 0,	//  				: not used
		SMALL_SSP		= 1,	//  instruction		: start sending positions
		SMALL_SSG		= 2,	//  instruction		: start sending gauges
		SMALL_VTA		= 3,	//  report			: vote action
		SMALL_TMS		= 4,	//  instruction		: time stop
		SMALL_STP		= 5,	//  instruction		: time step
		SMALL_RTP		= 6,	//  info			: race time packet (reply to GTH)
		SMALL_NLI		= 7		//  instruction		: set node lap interval
	}
	
	public enum ISF : ushort
	{
		ISF_RES_0		= 1,	// bit 0 : spare
		ISF_RES_1		= 2,	// bit 1 : spare
		ISF_LOCAL		= 4,	// bit 2 : guest or single player
		ISF_MSO_COLS	= 8,	// bit 3 : keep colours in MSO text
		ISF_NLP			= 16,	// bit 4 : receive NLP packets
		ISF_MCI			= 32	// bit 5 : receive MCI packets
	}

	public enum OG_FLAGS : int
	{
		OG_SHIFTLIGHT	= 1,	
		OG_FULLBEAM		= 2,
		OG_HANDBRAKE	= 4,
		OG_PITSPEED		= 8,
		OG_TC			= 16,
		OG_HEADLIGHTS	= 32,
		OG_SIGNAL_L		= 64,
		OG_SIGNAL_R		= 128,
		OG_REDLINE		= 256,
		OG_OILWARN		= 512,
		OG_1			= 1024,
		OG_2			= 2048,
		OG_3			= 4096,
		OG_TURBO			= 8192,
		OG_KM			= 16384,
		OG_BAR			= 32768
	}
	
    public enum DL_FLAGS : int
    {
	    DL_SHIFT = 1,			        // bit 0	- shift light
	    DL_FULLBEAM = 2,		    // bit 1	- full beam
	    DL_HANDBRAKE = 4,		    // bit 2	- handbrake
	    DL_PITSPEED = 8,		    // bit 3	- pit speed limiter
	    DL_TC = 16,				    // bit 4	- TC active or switched off
	    DL_SIGNAL_L = 32,		    // bit 5	- left turn signal
	    DL_SIGNAL_R = 64,		    // bit 6	- right turn signal
	    DL_SIGNAL_ANY = 128,		// bit 7	- shared turn signal
	    DL_OILWARN = 256,			// bit 8	- oil pressure warning
	    DL_BATTERY = 512,			// bit 9	- battery warning
	    DL_ABS = 1024,				// bit 10	- ABS active or switched off
	    DL_SPARE = 2048			    // bit 11
    };

	public enum ISS_STATE_FLAGS : int
	{
		ISS_GAME			= 1,	// in game (or MPR)
		ISS_REPLAY			= 2,	// in SPR
		ISS_PAUSED			= 4,	// paused
		ISS_SHIFTU			= 8,	// SHIFT+U mode
		ISS_SHIFTU_HIGH		= 16,	// HIGH view
		ISS_SHIFTU_FOLLOW	= 32,	// following car
		ISS_SHIFTU_NO_OPT	= 64,	// SHIFT+U buttons hidden
		ISS_SHOW_2D			= 128,	// showing 2d display
		ISS_FRONT_END		= 256,	// entry screen
		ISS_MULTI			= 512,	// multiplayer mode
		ISS_MPSPEEDUP		= 1024,	// multiplayer speedup option
		ISS_WINDOWED		= 2048,	// LFS is running in a window
		ISS_SOUND_MUTE		= 4096,	// sound is switched off
		ISS_VIEW_OVERRIDE	= 8192,	// override user view
		ISS_VISIBLE			= 16384 // InSim buttons visible
	}
	
	public enum CAM_VIEW : byte
	{
		VIEW_FOLLOW		= 0,	// 0 - arcade
		VIEW_HELI		= 1,	// 1 - helicopter
		VIEW_CAM		= 2,	// 2 - tv camera
		VIEW_DRIVER		= 3,	// 3 - cockpit
		VIEW_CUSTOM		= 4,	// 4 - custom
		VIEW_MAX		= 5,	// ???
	}
	
	public enum RACE_TYPE : byte
	{
		RT_NORACE		= 0,	// 0 - no race
		RT_RACE			= 1,	// 1 - race
		RT_QUAL			= 2		// 2 - qualifying
	}
	
	public enum WIND : byte
	{
		WIND_OFF		= 0,	// 0 - off
		WIND_WEAK		= 1,	// 1 - weak
		WIND_STRONG		= 2		// 2 - strong
	}

    public enum PITLANE : byte
    {
	    PITLANE_EXIT        = 0,	// 0 - left pit lane
	    PITLANE_ENTER       = 1,	// 1 - entered pit lane
	    PITLANE_NO_PURPOSE  = 2,	// 2 - entered for no purpose
	    PITLANE_DT          = 3,	// 3 - entered for drive-through
	    PITLANE_SG          = 4,	// 4 - entered for stop-go
	    PITLANE_NUM         = 5
    }

    public enum PTYPE : byte
    {
        FEMALE              = 1,
        AI                  = 2, 
        REMOTE              = 4
    }

    public enum PLAYER_FLAGS
    {  
        PIF_SWAPSIDE		= 1,
        PIF_RESERVED_2		= 2,
        PIF_RESERVED_4		= 4,
        PIF_AUTOGEARS		= 8,
        PIF_SHIFTER			= 16,
        PIF_RESERVED_32		= 32,
        PIF_HELP_B			= 64,
        PIF_AXIS_CLUTCH		= 128,
        PIF_INPITS			= 256,
        PIF_AUTOCLUTCH		= 512,
        PIF_MOUSE			= 1024,
        PIF_KB_NO_HELP		= 2048,
        PIF_KB_STABILISED	= 4096,
        PIF_CUSTOM_VIEW		= 8192
    }

    public enum BTN_STYLE : byte // BStyle : style flags for the button
    {
        ISB_C1			    = 1,		// you can choose a standard
        ISB_C2			    = 2,		// interface colour using
        ISB_C4			    = 4,		// these 3 lowest bits - see below
        ISB_CLICK		    = 8,		// click this button to send IS_BTC
        ISB_LIGHT		    = 16,		// light button
        ISB_DARK		    = 32,		// dark button
        ISB_LEFT		    = 64,		// align text to left
        ISB_RIGHT		    = 128		// align text to right
    }

    public enum BFN_STYLE // the fourth byte of IS_BFN packets is one of these
    {
	    BFN_DEL_BTN         = 0,		//  0 - instruction     : delete one button (must set ClickID)
	    BFN_CLEAR           = 1,		//  1 - instruction		: clear all buttons made by this insim instance
	    BFN_USER_CLEAR      = 2,		//  2 - info            : user cleared this insim instance's buttons
	    BFN_REQUEST         = 3		    //  3 - user request    : SHIFT+B or SHIFT+I - request for buttons
    }

    public enum MSO_TYPE
    {
	    MSO_SYSTEM          = 0,		// 0 - system message
	    MSO_USER            = 1,		// 1 - normal visible user message
	    MSO_PREFIX          = 2,		// 2 - hidden message starting with special prefix (see ISI)
	    MSO_O               = 3,		// 3 - hidden message typed on local pc with /o command
	    MSO_NUM
    }

}
