using System;
using System.Runtime.InteropServices;
using Tools;
using System.Text;

namespace d3d8_proxy
{
	public class GfxOutput
    {
        #region variables

        private IntPtr lib      = IntPtr.Zero;
						
		#region kernel32

		[DllImport("kernel32.dll", CharSet=CharSet.Auto)]
		static extern IntPtr LoadLibrary(string lpFileName); 

		[DllImport("kernel32.dll")]
		static extern IntPtr GetProcAddress(IntPtr hModule, string lpProcName); 

		[DllImport("kernel32.dll")]
		static extern bool FreeLibrary(IntPtr hModule); 

		#endregion

        #region d3d8 proxy

		public delegate void func1(bool val);		
        public func1	SetSpeedVisible;
        public func1    SetGearVisible;
        public func1    SetLedVisible;
        public func1    SetRpmVisible;

        public delegate void func2(int val);
        public func2    SetSpeed;
        public func2    SetGear;
        public func2    SetLed;
        public func2    SetRpm;

        public delegate void func3();
        public func3    ResetOG;

        public delegate void func4(int x, int y, int size);
        public func4    SetSpeedPosSize;
        public func4    SetGearPosSize;
        public func4    SetLedPosSize;
        public func4    SetRpmPosSize;

        public delegate void func5(int r, int g, int b);
        public func5    SetDigitsColor;     
   
        public delegate void func6(IntPtr hwnd);
        public func6    SetHwnd;

        public delegate void func7(StringBuilder filePath);
        public func7    GetFilePath;

        #endregion

        #region led type

        public enum Led  
        {
            Off         = 0,
            ShiftLight  = 1,
            Redline     = 2,
            OilWarn     = 3
        }

        #endregion

        #endregion

        public void Load(string path)
		{
			try
			{
				lib = LoadLibrary(path + "\\d3d8.dll");
				if (lib == IntPtr.Zero) 
					goto failed;
			
				IntPtr import = GetProcAddress(lib, "SetSpeedVisible");
				if (import == IntPtr.Zero)
					goto failed;
				
				SetSpeedVisible = (func1)Marshal.GetDelegateForFunctionPointer(import, typeof(func1));

                import = GetProcAddress(lib, "SetGearVisible");
				if (import == IntPtr.Zero)
					goto failed;

                SetGearVisible = (func1)Marshal.GetDelegateForFunctionPointer(import, typeof(func1));

                import = GetProcAddress(lib, "SetLedVisible");
                if (import == IntPtr.Zero)
                    goto failed;

                SetLedVisible = (func1)Marshal.GetDelegateForFunctionPointer(import, typeof(func1));

                import = GetProcAddress(lib, "SetRpmVisible");
                if (import == IntPtr.Zero)
                    goto failed;

                SetRpmVisible = (func1)Marshal.GetDelegateForFunctionPointer(import, typeof(func1));

                import = GetProcAddress(lib, "SetSpeed");
                if (import == IntPtr.Zero)
                    goto failed;

                SetSpeed = (func2)Marshal.GetDelegateForFunctionPointer(import, typeof(func2));

                import = GetProcAddress(lib, "SetGear");
                if (import == IntPtr.Zero)
                    goto failed;

                SetGear = (func2)Marshal.GetDelegateForFunctionPointer(import, typeof(func2));

                import = GetProcAddress(lib, "SetLed");
                if (import == IntPtr.Zero)
                    goto failed;

                SetLed = (func2)Marshal.GetDelegateForFunctionPointer(import, typeof(func2));

                import = GetProcAddress(lib, "SetRpm");
                if (import == IntPtr.Zero)
                    goto failed;

                SetRpm = (func2)Marshal.GetDelegateForFunctionPointer(import, typeof(func2));

                import = GetProcAddress(lib, "ResetOG");
                if (import == IntPtr.Zero)
                    goto failed;

                ResetOG = (func3)Marshal.GetDelegateForFunctionPointer(import, typeof(func3));

                import = GetProcAddress(lib, "SetSpeedPosSize");
                if (import == IntPtr.Zero)
                    goto failed;

                SetSpeedPosSize = (func4)Marshal.GetDelegateForFunctionPointer(import, typeof(func4));

                import = GetProcAddress(lib, "SetGearPosSize");
                if (import == IntPtr.Zero)
                    goto failed;

                SetGearPosSize = (func4)Marshal.GetDelegateForFunctionPointer(import, typeof(func4));

                import = GetProcAddress(lib, "SetLedPosSize");
                if (import == IntPtr.Zero)
                    goto failed;

                SetLedPosSize = (func4)Marshal.GetDelegateForFunctionPointer(import, typeof(func4));

                import = GetProcAddress(lib, "SetRpmPosSize");
                if (import == IntPtr.Zero)
                    goto failed;

                SetRpmPosSize = (func4)Marshal.GetDelegateForFunctionPointer(import, typeof(func4));

                import = GetProcAddress(lib, "SetDigitsColor");
                if (import == IntPtr.Zero)
                    goto failed;

                SetDigitsColor = (func5)Marshal.GetDelegateForFunctionPointer(import, typeof(func5));

                import = GetProcAddress(lib, "SetHwnd");
                if (import == IntPtr.Zero)
                    goto failed;

                SetHwnd = (func6)Marshal.GetDelegateForFunctionPointer(import, typeof(func6));

                import = GetProcAddress(lib, "GetFilePath");
                if (import == IntPtr.Zero)
                    goto failed;

                GetFilePath = (func7)Marshal.GetDelegateForFunctionPointer(import, typeof(func7));

				return;
				
			failed:
				Log.Error("d3d8.dll not found or incorrect version");
				
				FreeLibrary(lib);
				lib	= IntPtr.Zero;
			}
			catch(Exception ex)
			{
				Log.Error(ex.ToString());
			}
		}
		
		public void Free()
		{
			try
			{
				if (lib != IntPtr.Zero)
					FreeLibrary(lib);
			}
			catch(Exception ex)
			{
				Log.Error(ex.ToString());
			}
		}
		
		public bool LibraryLoaded
		{
			get
			{
				return (lib != IntPtr.Zero);
			}
		}
	}
}
