﻿using System;
using System.Collections.Generic;
using System.Text;

namespace DigitalGauges
{
    public class GaugeSettings
    { 
        public int speedVisibleType;
        public int gearVisibleType;
        public int ledVisibleType;        
        public int rpmVisibleType;

        public PosSize speedPosSize;        
        public PosSize gearPosSize;
        public PosSize ledPosSize;
        public PosSize rpmPosSize;

        public GaugeSettings()
        { 
            speedVisibleType    = (int)VisibleTypeSpeed.No;
            gearVisibleType     = (int)VisibleType.No;
            ledVisibleType      = (int)VisibleType.No;
            rpmVisibleType      = (int)VisibleType.No;
            
            speedPosSize        = new PosSize();
            gearPosSize         = new PosSize();
            ledPosSize          = new PosSize();
            rpmPosSize          = new PosSize();            
        }
    }

    public class GaugeState
    {
        public bool speedVisible;
        public int speed;
        public bool gearVisible;
        public int gear;
        public bool ledVisible;
        public int led;
        public bool rpmVisible;
        public int rpm;

        public bool inPits;

        public GaugeState()
        {
            speedVisible    = false;
            speed           = 0;
            gearVisible     = false;
            gear            = 1;     //neutral
            ledVisible      = false;
            led             = 0;
            rpmVisible      = false;
            rpm             = 0;
            
            inPits          = false;
        }
    }

    public enum VisibleType
    {
        Yes		= 0,
        No		= 1
    }

    public enum VisibleTypeSpeed
    {
        Yes		= 0,
        No		= 1,
        PitLane	= 2
    }

   	public class PosSize
	{
		public int x;    
		public int y;    
		public int size;

        public PosSize()
        {
            x       = 0;
            y       = 0;
            size    = 0;
        }
	}
}
