﻿/*
  Copyright (C) 2010 Mikael Forsberg <mikael@liveforspeed.se>
  
  This source file is subject to the MIT license.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Sparktris
{
    class ButtonRegistry : Dictionary<string, List<Button>>
    {
        public Button Add(string name, Button b)
        {
            if (ContainsKey(name))
            {
                this[name].Add(b);
            }
            else
            {
                Add(name, new List<Button> { b } );
            }

            return b;
        }

        public bool showGroup(string name)
        {
            return processGroup(name, ACT_SHOW);
        }

        public bool hideGroup(string name)
        {
            return processGroup(name, ACT_HIDE);
        }

        public void destroyAll()
        {
            foreach (KeyValuePair<string, List<Button>> list in this)
            {
                foreach (Button b in list.Value)
                {
                    b.hide(true);
                }
            }
        }

        private bool processGroup(string name, int action)
        {
            if (!ContainsKey(name))
            {
                return false;
            }

            foreach (Button b in this[name])
            {
                if (action == ACT_HIDE)
                {
                    b.hide();
                }
                else if (action == ACT_SHOW)
                {
                    b.show();
                }
            }

            return true;
        }

        private const int ACT_HIDE = 1;
        private const int ACT_SHOW = 2;
    }
}
