﻿/*
  Copyright (C) 2010 Mikael Forsberg <mikael@liveforspeed.se>
  
  This source file is subject to the MIT license.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Spark;

namespace Sparktris
{
    class ButtonFactory
    {
        public ButtonFactory(InSim insim)
        {
            this.insim = insim;
        }

        public Button createButton()
        {
            return new Button(insim, this);
        }

        public ClickableButton createClickableButton()
        {
            return new ClickableButton(insim, this);
        }
        
        public int takeButtonSlot()
        {
            if (slots.Count == 0)
            {
                throw new Exception("Out of button slots");
            }

            int slot = slots.Min();
            slots.Remove(slot);

            return slot;
        }

        public void returnButtonSlot(int slot)
        {
            slots.Add(slot);
        }

        private InSim insim;
        private List<int> slots = (List<int>) Enumerable.Range(1, 239).ToList<int>();
    }
}
