﻿/*
  Copyright (C) 2010 Mikael Forsberg <mikael@liveforspeed.se>
  
  This source file is subject to the MIT license.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Sparktris
{
    class ShapeFactory
    {
        public ShapeFactory()
        {
            random = new Random();
        }

        public Shape getShape()
        {
            switch (random.Next(0, 7))
            {
                case 0: return new BlockShape();
                case 1: return new RightElbowShape();
                case 2: return new LeftElbowShape();
                case 3: return new LineShape();
                case 4: return new TShape();
                case 5: return new SShape();
                case 6: return new ZShape();

                default: return new BlockShape();
            }
        }

        private Random random;
    }
}
