﻿/*
  Copyright (C) 2010 Mikael Forsberg <mikael@liveforspeed.se>
  
  This source file is subject to the MIT license.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Spark;
using Spark.Packets;

namespace Sparktris
{
    class ClickableButton : Button
    {
        public delegate void ClickHandler(ClickableButton b);
        public event ClickHandler clicked;

        public ClickableButton(InSim insim) : base(insim)
        {
            insim.Bind<IS_BTC>(onClick);
        }

        public ClickableButton(InSim insim, ButtonFactory factory) : base(insim, factory)
        {
            insim.Bind<IS_BTC>(onClick);
        }

        public override void show()
        {
            button.BStyle |= ButtonStyles.ISB_CLICK;
            base.show();
        }

        public void onClick(IS_BTC packet)
        {
            if (null != clicked && packet.ClickID == button.ClickID)
            {
                clicked(this);
            }
        }
    }
}