﻿/*
  Copyright (C) 2010 Mikael Forsberg <mikael@liveforspeed.se>
  
  This source file is subject to the MIT license.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Spark;
using Spark.Packets;

namespace Sparktris
{
    class Button
    {
        public Button(InSim insim)
        {
            this.insim = insim;

            button.ReqI = 1;
            button.Text = "";
        }

        public Button(InSim insim, ButtonFactory factory) : this(insim)
        {
            this.factory = factory;
        }

        public void setClickId(int clickId)
        {
            button.ClickID = (byte) clickId;
        }

        public int getClickId()
        {
            return (int) button.ClickID;
        }

        public void setText(String text)
        {
            button.Text = text;
        }

        public String getText()
        {
            return button.Text;
        }

        public void setSize(int width, int height)
        {
            button.W = (byte) width;
            button.H = (byte) height;
        }

        public int getWidth()
        {
            return (int) button.W;
        }

        public int getHeight()
        {
            return (int) button.H;
        }

        public void setPosition(int x, int y)
        {
            button.L = (byte) x;
            button.T = (byte) y;
        }

        public void move(int x, int y)
        {
            button.L += (byte) x;
            button.T += (byte) y;
        }

        public int getPositionX()
        {
            return (int) button.L;
        }

        public int getPositionY()
        {
            return (int) button.T;
        }

        public void setStyle(ButtonStyles style)
        {
            button.BStyle = style;
        }

        public ButtonStyles getStyle()
        {
            return button.BStyle;
        }

        public virtual void show()
        {
            if (!changed())
            {
                return;
            }

            signature = getSignature();

            if (button.ClickID < 1 && null != factory)
            {
                button.ClickID = (byte) factory.takeButtonSlot();
            }

            insim.Send(button);
        }

        public void hide()
        {
            if (signature != "")
            {
                signature = "";
                insim.Send(new IS_BFN { SubT = ButtonFunction.BFN_DEL_BTN, ClickID = button.ClickID });
            }
        }

        public void hide(bool unslot)
        {
            hide();

            if (null != factory && unslot)
            {
                factory.returnButtonSlot((int) button.ClickID);
                button.ClickID = (byte) 0;
            }
        }

        protected string getSignature()
        {
            return String.Format("{0}.{1}.{2}.{3}.{4}.{5}", button.L, button.T, button.W, button.H, button.Text, (int) button.BStyle);
        }

        protected bool changed()
        {
            return signature != getSignature();
        }

        protected InSim insim;
        protected ButtonFactory factory;

        protected IS_BTN button    = new IS_BTN();
        protected string signature = "";
    }
}
