﻿/*
  Copyright (C) 2010 Mikael Forsberg <mikael@liveforspeed.se>
  
  This source file is subject to the MIT license.
*/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace Sparktris
{
    public partial class SparktrisWindow : Form
    {
        public SparktrisWindow()
        {
            InitializeComponent();
            this.FormClosing += new FormClosingEventHandler(delegate { stopGame(); } );
        }

        private void startStopButton_Click(object sender, EventArgs e)
        {
            if (startStopButton.Text == "Start")
            {
                if (startGame())
                {
                    startStopButton.Text = "Stop";
                }
            }
            else
            {
                startStopButton.Text = "Start";
                stopGame();
            }
        }

        private bool startGame()
        {
            if (gameThread == null)
            {
                try
                {
                    game = new Game(textboxIpAddress.Text, Convert.ToInt32(textboxPort.Text), textboxPassword.Text);
                    game.ending += new Game.EndingHandler(game_ending);
                }
                catch (Exception)
                {
                    MessageBox.Show("Please format your connection details properly", "Sparktris");
                    return false;
                }

                gameThread = new Thread(new ThreadStart(game.run));
                gameThread.Start();
            }

            return true;
        }

        void game_ending()
        {
            Invoke((MethodInvoker) delegate {
                startStopButton.Text = "Start";
                stopGame();
            } );
        }

        private void stopGame()
        {
            if (gameThread != null)
            {
                gameThread.Abort();
                gameThread = null;
            }
        }

        private Game game;
        private Thread gameThread;
    }
}
