﻿/*
  Copyright (C) 2010 Mikael Forsberg <mikael@liveforspeed.se>
  
  This source file is subject to the MIT license.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Sparktris
{
    abstract class Shape : List<List<int>>
    {
        public void setPosition(int x, int y)
        {
            this.x = x;
            this.y = y;
        }

        public void move(int x, int y)
        {
            this.x += x;
            this.y += y;
        }

        public void rotate()
        {
            rotate(1);
        }

        public void rotate(int distance)
        {
            shapeIndex += distance;

            while (shapeIndex < 0)
            {
                shapeIndex = Count + shapeIndex;
            }

            if (shapeIndex >= Count)
            {
                shapeIndex %= Count;
            }

            shape = this[shapeIndex];
        }

        public int x      = 0;
        public int y      = 0;
        public int width  = 0;
        public int height = 0;

        public List<int> shape;

        private int shapeIndex = 0;

        protected static int sprite(string bin)
        {
            char[] chars = bin.ToCharArray();
            int result = 0;

            for (int i = 0; i < chars.Length; ++i)
            {
                result += chars[i] == '1' ? 1 << i : 0;
            }

            return result;
        }
    }
}
