VERSION 5.00
Begin VB.Form frmMain 
   AutoRedraw      =   -1  'True
   BorderStyle     =   1  'Fixed Single
   Caption         =   "OutGauge Test"
   ClientHeight    =   2415
   ClientLeft      =   45
   ClientTop       =   375
   ClientWidth     =   5415
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   2415
   ScaleWidth      =   5415
   StartUpPosition =   2  'CenterScreen
   Begin OutGaugeTest.okSocket theSocket 
      Left            =   120
      Top             =   120
      _ExtentX        =   450
      _ExtentY        =   423
   End
   Begin VB.Label lblSpeed 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "(speed) @ (RPM)"
      BeginProperty Font 
         Name            =   "Tahoma"
         Size            =   20.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   240
      TabIndex        =   0
      Top             =   960
      Width           =   4935
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'This can be controlled by 5 lines in the cfg.txt file :
'OutGauge Mode 0        :0-off 1-driving 2-driving+replay
'OutGauge Delay 1       :minimum delay between packets (100ths of a sec)
'OutGauge IP 0.0.0.0    :IP address to send the UDP packet
'OutGauge Port 0        :IP port
'OutGauge ID 0          :if not zero, adds an identifier to the packet

'Each update sends the following UDP packet :
Private Type OutGaugePacket
    Time(0 To 3) As Byte        'unsigned    Time;           // time in milliseconds (to check order)
    Car(0 To 3) As Byte         'char        Car[4];         // Car name
    Flags(0 To 1) As Byte       'word        Flags;          // Info (see OG_x below)
    Gear As Byte                'byte        Gear;           // Reverse:0, Neutral:1, First:2...
    SpareB As Byte              'byte        SpareB;
    Speed As Single             'float       Speed;          // M/S
    RPM As Single               'float       RPM;            // RPM
    Turbo As Single             'float       Turbo;          // BAR
    EngTemp As Single           'float       EngTemp;        // C
    Fuel As Single              'float       Fuel;           // 0 to 1
    OilPressure As Single       'float       OilPressure;    // BAR
    OilTemp As Single           'float       OilTemp;        // C
    DashLights(0 To 3) As Byte  'unsigned    DashLights;     // Dash lights available (see DL_x below)
    ShowLights(0 To 3) As Byte  'unsigned    ShowLights;     // Dash lights currently switched on
    Throttle As Single          'float       Throttle;       // 0 to 1
    Brake As Single             'float       Brake;          // 0 to 1
    Clutch As Single            'float       Clutch;         // 0 to 1
    Display1(0 To 15) As Byte   'char        Display1[16];   // Usually Fuel
    Display2(0 To 15) As Byte   'char        Display2[16];   // Usually Settings
    ID As Long                  'int         ID;             // optional - only if OutGauge ID is specified
End Type

'OG_x - bits for OutGaugePack Flags
Private Const OG_TURBO As Long = 8192 '#define OG_TURBO        8192    // show turbo gauge
Private Const OG_KM As Long = 16384   '#define OG_KM           16384   // if not set - user prefers MILES
Private Const OG_BAR As Long = 32768  '#define OG_BAR          32768   // if not set - user prefers PSI

'DL_x - bits for OutGaugePack DashLights and ShowLights
Private Const DL_SHIFT As Long = 1        '// bit 0    - shift light
Private Const DL_FULLBEAM As Long = 2     '// bit 1    - full beam
Private Const DL_HANDBRAKE As Long = 4    '// bit 2    - handbrake
Private Const DL_PITSPEED As Long = 8     '// bit 3    - pit speed limiter
Private Const DL_TC As Long = 16          '// bit 4    - TC active or switched off
Private Const DL_SIGNAL_L As Long = 32    '// bit 5    - left turn signal
Private Const DL_SIGNAL_R As Long = 64    '// bit 6    - right turn signal
Private Const DL_SIGNAL_ANY As Long = 128 '// bit 7    - shared turn signal
Private Const DL_OILWARN As Long = 256    '// bit 8    - oil pressure warning
Private Const DL_BATTERY As Long = 512    '// bit 9    - battery warning
Private Const DL_ABS As Long = 1024       '// bit 10   - ABS active or switched off
Private Const DL_SPARE As Long = 2048     '// bit 11
Private Const DL_NUM As Long = 4096

Private lngTheSocket As Long

Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)

Private Sub Form_Load()
    If theSocket.Initilize("MrOutGauge") Then
        lngTheSocket = theSocket.ListenTo("UDP", 55)
        
        Print "Listening on port 55"
    Else
        Print "Could not initlize winsock!?"
    End If
End Sub

Private Sub theSocket_Received(lngSocket As Long, Data() As Byte)
    If lngSocket = lngTheSocket Then
        Dim Packet As OutGaugePacket, lngFlags As Long, dblShowLights As Double
        
        CopyMemory Packet, Data(0), LenB(Packet)
        
        'check which speed is preferred then display
        lngFlags = BytesWordToLong(Packet.Flags, 0)
        If IsBitSet(lngFlags, OG_KM) Then
           lblSpeed.Caption = Format(Packet.Speed * 3.6, "##0") & " kph"
        Else
           lblSpeed.Caption = Format(Packet.Speed * 2.23693629, "##0") & " mph"
        End If
        lblSpeed.Caption = lblSpeed.Caption & " @ " & Format(Packet.RPM, "####0") & " RPM"
        
        'print flag or clear form
        dblShowLights = BytesUnsignedToDouble(Packet.ShowLights, 0)
        If IsBitSet(dblShowLights, DL_HANDBRAKE) Then
            Print "Handbrake!"
        Else
            Me.Cls
        End If
    End If
End Sub

'simple bitwise check
Private Function IsBitSet(ByVal dblData As Double, ByVal lngBit As Long) As Boolean
    IsBitSet = ((dblData And lngBit) = lngBit)
End Function

'convert from a C char array to a string
Private Function BytesToString(bytData() As Byte, ByVal intStart As Integer, ByVal intLength As Integer) As String
    Dim i As Integer, strString As String
    
    'copy the bytes
    For i = 0 To intLength - 1
        If bytData(intStart + i) = 0 Then
            Exit For
        Else
            strString = strString & Chr$(bytData(intStart + i))
        End If
    Next i
    
'Don't need this for OutGauge, right?
'    'remove lfs codes, colors first
'    For i = 0 To 9
'        strString = Replace(strString, "^" & i, "")
'    Next i
'
'    'special LFS characters
'    strString = Replace(strString, "^a", "*")
'    strString = Replace(strString, "^c", ":")
'    strString = Replace(strString, "^d", "\")
'    strString = Replace(strString, "^l", "<")
'    strString = Replace(strString, "^q", "?")
'    strString = Replace(strString, "^r", ">")
'    strString = Replace(strString, "^s", "/")
'    strString = Replace(strString, "^t", """")  'double quote
'    strString = Replace(strString, "^v", "|")
'
'    'language codes
'    strString = Replace(strString, "^L", "")    'Latin 1
'    strString = Replace(strString, "^G", "")    'Greek
'    strString = Replace(strString, "^C", "")    'Cyrillic
'    strString = Replace(strString, "^J", "")    'Japanese
'    strString = Replace(strString, "^E", "")    'Central Europe
'    strString = Replace(strString, "^T", "")    'Turkish
'    strString = Replace(strString, "^B", "")    'Baltic
    
    BytesToString = strString
End Function

'convert from a C word in a byte array to a long
Private Function BytesWordToLong(bytData() As Byte, ByVal intStart As Integer) As Long
    BytesWordToLong = bytData(intStart) + (CLng(bytData(intStart + 1)) * 256)
End Function

'convert from a C unsigned int in a byte array to a double
Private Function BytesUnsignedToDouble(bytData() As Byte, ByVal intStart As Integer) As Double
    BytesUnsignedToDouble = bytData(intStart) + (CDbl(bytData(intStart + 1)) * 256) + (CDbl(bytData(intStart + 2)) * 65536) + (CDbl(bytData(intStart + 3)) * 16777216)
End Function
