<?php

/* Functions */

// Inject one string into another at a spesific point.
function str_inject($sourceStr, $injectStr, $injectPos)
{
	if ($injectPos >= strlen($sourceStr)) {
		trigger_error('Inject posisition is greater then the length of the source string, concating string!', E_USER_NOTICE);
		return str_pad($sourceStr, $injectPos) . $injectStr;
	}

	return substr($sourceStr, 0, $injectPos) . $injectStr . substr($sourceStr, $injectPos);
}

// Convert LFS Strings into ECMA-48 Console Codes.
function lfs_str_convert_console($str, $strBits = 0)
{
	$ΔARY = array("\033[30m", "\033[31m", "\033[32m", "\033[33m", "\033[34m", "\033[35m", "\033[36m", "\033[37m", "\033[0m", "\033[0m");
	for ($i = 0, $j = 1, $l = strlen($str); $i < $l; ++$i, ++$j)
	{
		/* Handle Color Codes */
		if ($str{$i} == '^' && is_numeric($str{$j}))
		{
			// Save Δ Change Array Key Number & Δ Len of Replace Str;
			$ΔAKN = $str[$j]; # Δ (Change) Array Key Number;
			$ΔLen = strlen($ΔARY[$ΔAKN]); # Δ (Change) Array Value Len. 
			// Remove The Formatting
			$str[$i] = NULL; # Remove ^
			$str[$j] = NULL; # Remove Int.
			// Place ECMA-48 Charaters into String.
			$str = str_inject($str, $ΔARY[$ΔAKN], $i);
			// Move Str Pointers Past Δ
			$i += $ΔLen;
			$j += $ΔLen;
			$l += $ΔLen; # And Add Δ to Str Len.
		}
		/* Handle Language Page */
	}
	return $str;
}

// echo results to output.
echo lfs_str_convert_console(file_get_contents('/home/dygear/Desktop/fom.txt')) . "\033[0m";

?>
