--[[
  ginfo!!!

]]

botnick = "Luabot"
channel = "#lfs_irc"
to_lfs = os.time()
-- ip server
irc_server = "192.168.6.14"
irc_port = 6667

proc1 = coroutine.create(function ()

socket = require("socket")
client = socket.tcp()
client:settimeout(0)

res,err = client:connect(irc_server, irc_port)
print("connect",res,err)

function send(txt)
    local res = client:send(txt.."\r\n")
    if not res then
        print("send","error")
    else
--        print("send",txt)
    end
end

function recv()
    local res, err = client:receive('*l')
    if err == 'timeout' then
        return res, false, true
    end
    return res, err, false
end

function future()
    local events = {}
    local event =
        function(seconds, callback)
            local cb = callback
            local to = os.time()+seconds
            return
                function()
                    if os.time() >= to then
                        cb()
                        return true
                    else
                        return false
                    end
                end
        end

    return {
        register =
            function(seconds, callback)
                table.insert(events,event(seconds,callback))
            end,
        check =
            function()
                local res
                for k,v in pairs(events) do
                    res = v()
                    if res then
                        table.remove(events,k)
                    end
                end
            end
    }
end


-- Identify yourself
send("NICK "..botnick)
send("USER "..botnick.." 0 * :I am from the moon")

timer = future()
--timer.register(20,function() send("JOIN #Main") end)
--timer.register(25,function() send("PRIVMSG #Main :I HAVE ARRIVED") end)
timer.register(5,function() send("JOIN "..channel) end)
--timer.register(10,function() send("PART #Main") end)

------------------------------------------------------------------------
repeat

    local res, err, timeout = recv()

    if not err and not timeout then

        if string.sub(res,1,4) == "PING" then
            send(string.gsub(res,"PING","PONG",1))
        elseif string.sub(res,1,1) ~= ":" then
            print("INFO", res)
        elseif (string.find(res,"PRIVMSG "..channel) ~= nil) then
            local nick = string.match(res, "^:(.+)!.+ PRIVMSG "..channel)
            to_lfs = string.match(res, "PRIVMSG "..channel.." :(.+)")
--  ^ 
            to_lfs = luaLFS:stripctrlchars(to_lfs)
--   
            if (to_lfs == "!list") then
                for k,v in pairs(users) do
--                    print(k,v.pname,v.uname,v.admin)
                    timer.register(1,function() send("PRIVMSG "..nick.." :"..luaLFS:stripctrlchars(v.uname)) end)
                end
            elseif (false) then
            -- - 
            else
                to_lfs,r = string.gsub(to_lfs,"\1ACTION (.+)\1","%1")
                local msg = "^7"..nick.." :^2 ^C"..to_lfs
                if (r ~= 0) then
                    msg = "/me "..msg
                end

                print("(irc->lfs) "..msg)
                if (msg:len() < 64) then
			for k,v in pairs(users) do
				luaLFS:mtc(k,0,msg)
			end

		else timer.register(1,function() send("PRIVMSG "..channel.." :\1ACTION message too long. max 63 char\1") end)
                end
            end
        elseif (string.find(res,"PRIVMSG "..botnick) ~= nil) then
            local nick = string.match(res, "^:(.+)!.+ PRIVMSG "..botnick)
            local command = string.match(res, "PRIVMSG "..botnick.." :(.+)")
            if (command == "exit") then send("QUIT"); os.exit() end
            if (command == "!laps") then luaLFS:mst("/laps=100") end

        else
--            print("data ",res)--
            local prefix, command, params = string.match(res, "^:([^ ]+) ([^ ]+)(.*)$")
            local params = string.sub(params,2)
            if prefix then
--                print("pfx", ">"..prefix.."<")--
--                print("cmd", ">..command..<")--
                local param1, param2 = string.match(params,"^([^:]+) :(.*)$")
                if param1 then
--                    print("prm1",">..param1..<")--
--                    print("prm2",">..param2..<")--
                else
--                    print("prm",">..params..<")--
                end
            else
                print("UNK",res)
            end
        end
        print("data ",res)
    end
    timer.check()

coroutine.yield()
until err

client:close()
end)

function test(imsg)
    local t = luaLFS:mso(imsg)
    local from_lfs = luaLFS:stripctrlchars(t.msg)
--    print (from_lfs.."="..to_lfs)
    if (string.find(from_lfs,to_lfs) == nil) then
        for k,v in pairs(racers) do
            from_lfs,repl = from_lfs:gsub("(.+ :) ","\0032%1\3 ")
            if  (repl ~= 0) then
                break
            end
        end
        print("(lfs->irc "..from_lfs)
        if (repl == 0) then
            timer.register(1,function() send("PRIVMSG "..channel.." :"..from_lfs:gsub("(.+)","\1ACTION %1\1")) end)
        else
            timer.register(1,function() send("PRIVMSG "..channel.." :"..from_lfs) end)
        end
    end
    to_lfs = os.time() --         lfs  
    coroutine.resume(proc1)
end
evt_bind(ISP_MSO, test)

function tr()
	coroutine.resume(proc1)
end
evt_bind(ISP_MCI, tr)

function init(imsg)
	racers = {}
	users = {}
	plid2ucid = {}
	admins = {}
	luaLFS:small(0, SMALL_NLI, 100)
	luaLFS:tiny(1, TINY_NPL)
	luaLFS:tiny(1, TINY_NCN)
end
evt_bind(EVT_CONNECTED, init)

function racers(imsg)
	local npl = luaLFS:npl(imsg)
	racers[npl.plid] = npl.pname
	plid2ucid[npl.plid] = npl.ucid
end
evt_bind(ISP_NPL, racers)

function is_ncn(imsg)
	local ncn = luaLFS:ncn(imsg)
--    
    if (ncn.ucid ~=0) then users[ncn.ucid] = {pname = ncn.pname, uname = ncn.uname, admin = ncn.admin} end
end
evt_bind(ISP_NCN, is_ncn)

--  - ,           .
evt_bind(ISP_CNL, init)
evt_bind(ISP_CPR, init)
evt_bind(ISP_PLL, init)

function thread()
	coroutine.resume(proc1)
--	print(os.time())
end
evt_bind(EVT_THREAD, thread)
