/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#include "hooks_translate.h"

const struct translate_table_t translate_table[6] = {
    { ISP_NONE, "None" },
    { ISP_ISI, "ISI" },
    { ISP_VER, "VER" },
    { ISP_TINY, "TINY" },
    { ISP_SMALL, "SMALL" },
    { ISP_STA, "STATE" },
};

void translate_recv(struct insim_t *I, void *ctx, void *data, unsigned int size)
{
        unsigned int p = (unsigned int)*((char *)data+1);
        printf(" *** Translating %d...", p);
        if (p > 6)
            printf("Unknown packet\n");
        else
            printf("%s\n", translate_table[p].name);

        return;
}

void translate_small(struct IS_SMALL *t)
{
}

void translate_tiny(struct IS_TINY *t)
{
}
