/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/

#ifndef LHTIMEOUT
#define LHTIMEOUT

#include "lib_insim.h"

struct hkeepalive_t
{
    // Recv'ed ISP_VERS?
    BOOL gotvers;
    // Connection time
    time_t conntime;
    // Last contact from LFS
    time_t last;
};

void hkeepalive_create(struct insim_t *I, void **ctx);

void hkeepalive_connected(struct insim_t *I, void *ctx);

void hkeepalive_recv(struct insim_t *I, void *ctx, void *data, unsigned int size);

void hkeepalive_prerecv(struct insim_t *I, void *ctx);

void hkeepalive_close(struct insim_t *I, void *ctx);

//my include (repeat)
void hkeepalive_thread(struct insim_t *I, void *ctx);

#endif
