config =
{
	--- Configuration for luaLFS
	--- Must exist
	luaLFS =
	{
		-- Number of times luaLFS attempts to connect to LFS - overridden
		-- if auto_reconnect is set
		connection_attempts = 5,
		-- Skips a sleep call on connection attempt
		connection_fast = 0, 
		-- ADVANCED
		--
		-- Auto reconnect
		-- This is a VERY dangerous setting. It effectively puts luaLFS
		-- into a recursive loop, trying to connect FOREVER.
		-- If set it overrides connection_attempts
		-- It is HIGHLY recommended that it remains set to 0, except for servers
		-- Use at your own risk
		auto_reconnect = 0,
		-- polling is the amount of time between select() timeouts
		-- also used for the amount of time between connection attempts
		polling = 1,
		-- Minimum timeout in seconds before we assume LFS has been closed,
		timeout = 70,
		-- verbosity of luaLFS
		verbose = 0,
	},
	--- Configuration for LFS
	--- Must exist
	LFS =
	{
		-- The address of computer running LFS
		address = "95.161.3.8",
--		address = "127.0.0.1",
		-- The port LFS is listening for InSim connections on
		port = 29994,
		-- The administrative password
		password = "bAzGaIKHmBJI",
--		password = "",
		-- Number of ms between NLP or MCI packets (0=none)
		interval = 100,
		-- Flags
		-- Example; Requests both NLP and MCI packets;
		-- flags = bit.bor(ISF_NLP, ISF_MCI),
		--flags = bit.bor(ISF_LOCAL, ISF_MCI, ISF_NLP),
		--flags = bit.bor(ISF_LOCAL),
		flags = bit.bor(ISF_MCI),
		-- Character to prefix all messaged destined specifically for the host
		prefix = "!",
	},
}
