﻿####	CIRCULAR DRIFT METER
####	=====================

####	For Lapper V5.925 and later

####	by Sinanju 

####	Original Drift Meter by Sinanju
####	Circular idea by Sinanju

#############################################################################
# Ver 0.1 - 16 Feb 2010 Initial release
# Ver 0.2 - 16 Feb 2010 Minor update to display message that drift scores not recorded on outlaps
#############################################################################

##################
#Drifting options#
##################

$DriftDatabase = "./DriftPB";
$MinimumDriftSpeed = 39; # Minimum speed in km/h to maintain. Driving below that speed will reset score
$MinimumDriftAngle = 5; # Minimum angel to maintain. When angle is below value, score is reset
$MaximumDriftAngle = 75; # Maximum angel to maintain. When angle is above value, score is reset
$GoodDriftScore = 2500; # Value to be reached to execute action on good drift score
$MinimumDriftScore = 100; # Minimum drift score required


CatchEvent OnDriftScore( $userName ) # This is the section for displaying the Drift Meter

	$AngleVelocity = GetCurrentPlayerVar( "AngleVelocity" );
	$DriftScore = GetCurrentPlayerVar( "DriftScore" );
	$LastDriftScore = GetCurrentPlayerVar( "LastDriftScore" );

	openPrivButton( "circledrift_back",97,57,165,165,1,-1,0,"^1•"); # red background
	openPrivButton( "circledrift_back1",100,60,159,159,1,-1,0,"^3•"); # yellow foreground
	openPrivButton( "circledrift_thisdrift",169,126,20,5,1,-1,0,"^1This Drift"); # red
	openPrivButton( "circledrift_lastdriftscore",169,128,20,12,1,-1,0,langEngine( "%{circledrift_score}%" , $LastDriftScore ) );
	openPrivButton( "circledrift_lapscore",169,148,20,15,1,-1,0,langEngine( "%{circledrift_combo}%" , $DriftScore ) );
	openPrivButton( "circledrift_maxscore",169,159,20,5,1,-1,0,"^0Lap Score"); # black


	IF( $AngleVelocity < 0 )

	THEN
		$AngleVelocity = -$AngleVelocity ;

		SetCurrentPlayerVar("Angle_Reverse",$AngleVelocity);

		closePrivButton( "circledrift_anglerev&circledrift_angle");
		openPrivButton( "circledrift_anglerev",169,136,20,17,1,-1,0,langEngine( "%{circledrift_anglerev}%" , GetCurrentPlayerVar( "Angle_Reverse")));

	ELSE

		closePrivButton( "circledrift_anglerev&circledrift_angle");
		openPrivButton( "circledrift_angle",169,136,20,17,1,-1,0,langEngine( "%{circledrift_angle}%" , $AngleVelocity ));

	ENDIF

EndCatchEvent


Event OnDriftResetScore( $userName ) # Player event

	openPrivButton( "circledrift_lastdriftscore",169,128,20,12,1,-1,0, "^10"  );
	openPrivButton( "circledrift_lapscore",169,148,20,15,1,-1,0,"^10"  );

IF (GetCurrentPlayerVar( SessLaps ) <1)
THEN
	openPrivButton( "circledrift_angle",164,137,30,14,1,-1,0,"^1> Scores not saved <%at% "  );
	openPrivButton( "circledrift_anglerev",164,137,30,14,1,-1,0," %at%^1> on your outlap <"  );
ELSE
	openPrivButton( "circledrift_angle",164,137,30,14,1,-1,0,"^1> Too slow <%at% "  );
	openPrivButton( "circledrift_anglerev",164,137,30,14,1,-1,0," %at%^1> lost scores <"  );
ENDIF
EndEvent


################################

Lang "EN"
	circledrift_angle = "^1< {0}^2°";
	circledrift_anglerev = "^2{0}^1° ^2>";
	circledrift_combo = "^1{0}";
	circledrift_score = "^4+ ^0{0}";
EndLang

