<?php

class packets {
	function main() {
		foreach ($this->packet as $define => $packet) {
			$this->compact[$define] = '';
			$this->enlarge[$define] = '';
			foreach ($packet as $vname => $datatype) {
				$Numb = '';
				if (!isset($this->datatype[$datatype])) {
					for ($i = 0, $l = strlen($datatype); $i < $l; $i++) {
						if (is_numeric(substr($datatype, $i, 1))) {
							$Numb .= substr($datatype, $i, 1);
						}
					}
					$datatype = substr($datatype, strlen($Numb));
				}
				$this->compact[$define] .= "{$this->datatype[$datatype]['Pack']}{$Numb}";
				$this->enlarge[$define] .= "{$this->datatype[$datatype]['Pack']}{$Numb}{$vname}/";
			}
		}
	}
	function make() {
		
	}
	function read($packet) {
# Reverse Packet Name Arrays
$ISP = array('ISP_NONE', 'ISP_ISI', 'ISP_VER', 'ISP_TINY', 'ISP_SMALL', 'ISP_STA', 'ISP_SCH', 'ISP_SFP', 'ISP_SCC', 'ISP_CPP', 'ISP_ISM', 'ISP_MSO', 'ISP_III', 'ISP_MST', 'ISP_MTC', 'ISP_MOD', 'ISP_VTN', 'ISP_RST', 'ISP_NCN', 'ISP_CNL', 'ISP_CPR', 'ISP_NPL', 'ISP_PLP', 'ISP_PLL', 'ISP_LAP', 'ISP_SPX', 'ISP_PIT', 'ISP_PSF', 'ISP_PLA', 'ISP_CCH', 'ISP_PEN', 'ISP_TOC', 'ISP_FLG', 'ISP_PFL', 'ISP_FIN', 'ISP_RES', 'ISP_REO', 'ISP_NLP', 'ISP_MCI', 'ISP_MSX', 'ISP_MSL', 'ISP_CRS', 'ISP_BFN', 'ISP_AXI', 'ISP_AXO', 'ISP_BTN', 'ISP_BTC', 'ISP_BTT', 'ISP_RIP', 'ISP_SSH');
$TINY = array('TINY_NONE', 'TINY_VER', 'TINY_CLOSE', 'TINY_PING', 'TINY_REPLY', 'TINY_VTC', 'TINY_SCP', 'TINY_SST', 'TINY_GTH', 'TINY_MPE', 'TINY_ISM', 'TINY_REN', 'TINY_CLR', 'TINY_NCN', 'TINY_NPL', 'TINY_RES', 'TINY_NLP', 'TINY_MCI', 'TINY_REO', 'TINY_RST', 'TINY_AXI', 'TINY_AXC', 'TINY_RIP');
$SMALL = array('SMALL_NONE', 'SMALL_SSP', 'SMALL_SSG', 'SMALL_VTA', 'SMALL_TMS', 'SMALL_STP', 'SMALL_RTP', 'SMALL_NLI');
		$offset = 0;
		$return = unpack('CSize/CType', $packet);	# Read Header
		switch ($return['Type']) {
			case ISP_TINY:
				$return += unpack('CReqI/CSubT', substr($packet, 2, 2));
				$return['SubT'] = $TINY[$return['SubT']];
			break;
			case ISP_SMALL:
				$return += unpack('CReqI/CSubT', substr($packet, 2, 2));
				$return['SubT'] = $SMALL[$return['SubT']];
			break;
			case ISP_CPP:
				$return += unpack('CReqI/CZero', substr($packet, 2, 2));
				$return['Pos'] = array();
				$return['Pos'] = unpack('lX/lY/lZ', substr($packet, 4, 12));
				$return += unpack('vH/vP/vR/CVicePLID/CInGameCam/fFOV/vTime/vFlags', substr($packet, 16, 16));
			break;
			case ISP_MCI:
				$return += unpack('CReqI/CNumC', substr($packet, 2, 2));
				$return['Info'] = array();
				for ($i = 0; $i < $return['NumC']; $i++)
					$return['Info'][$i] = unpack('vNode/vLap/CPLID/CPosition/CInfo/CSp3/lX/lY/lZ/vSpeed/vDirection/vHeading/sAngVel', substr($packet, 4 + ($i * 28), 28));
			break;
			case ISP_NLP:
				$return += unpack('CReqI/CNumP', substr($packet, $offset += 2, 2));
				$return['Info'] = array();
				for ($i = 0; $i < $return['NumP']; $i++)
					$return['Info'][$i] = unpack('vNode/vLap/CPLID/CPosition', substr($packet, 4 + ($i * 6), 6));
			break;
			default:
				$return = unpack($this->enlarge[$return['Type']], $packet);
			break;
		}
		$return['Type'] = $ISP[$return['Type']];
		return $return;
	}
	function __construct() {
		# datatypes
		$this->datatype	= array(
			'char'		=>	array(	# 1-byte character
							'Size' => 1,
							'Pack' => 'a'	# NUL-padded string
						),
			'byte'		=>	array(	# 1-byte unsigned integer
							'Size' => 1,
							'Pack' => 'C'	# unsigned char
						),
			'word'		=>	array(	# 2-byte unsigned integer
							'Size' => 2,
							'Pack' => 'v'	# unsigned short (always 16 bit, little endian byte order)
						),
			'short'		=>	array(	# 2-byte signed integer Defined in ISP_MCI CompCar Struct
							'Size' => 2,
							'Pack' => 's'	# signed short (always 16 bit, machine byte order)
						),
			'unsigned'	=>	array(	# 4-byte unsigned integer
							'Size' => 4,
							'Pack' => 'V'	# unsigned long *int* (always 32 bit, little endian byte order)
						),
			'int'		=>	array(	# 4-byte signed integerz
							'Size' => 4,
							'Pack' => 'l'	# signed long *int* (always 32 bit, little endian byte order)
						),
			'float'		=>	array(	# 4-byte float
							'Size' => 4,
							'Pack' => 'f'	# float (machine dependent size and representation)
						),
			'NodeLap'	=>	array(	# 6-byte struct
							'Size' => 6,
							'Pack' => 'x'	# /!\ Handled Elsewhere /!\
						),
			'Vec'		=>	array(	# 12-byte (3 * 4-byte int) Defined in ISP_CPP Packet
							'Size' => 12,
							'Pack' => 'x'	# /!\ Handled Elsewhere /!\
						),
			'CompCar'	=>	array(	# 28-byte struct
							'Size' => 28,
							'Pack' => 'x'	# /!\ Handled Elsewhere /!\
						)
		);
		# structs
		$this->struct	= array(
			'NodeLap'	=> array(
				'Node'		=> 'word',		# current path node
				'Lap'		=> 'word',		# current lap
				'PLID'		=> 'byte',		# player's unique id
				'Position'	=> 'byte',		# current race position : 0 = unknown, 1 = leader, etc...
			),
			'CompCar'	=> array(
				'Node'		=> 'word',		# current path node
				'Lap'		=> 'word',		# current lap
				'PLID'		=> 'byte',		# player's unique id
				'Position'	=> 'byte',		# current race position : 0 = unknown, 1 = leader, etc...
				'Info'		=> 'byte',		# flags and other info - see below
				'Sp3'		=> 'byte',		# 0
				'X'			=> 'int',		# X map (65536 = 1 metre)
				'Y'			=> 'int',		# Y map (65536 = 1 metre)
				'Z'			=> 'int',		# Z alt (65536 = 1 metre)
				'Speed'		=> 'word',		# speed (32768 = 100 m/s)
				'Direction'	=> 'word',		# direction of car's motion : 0 = world y direction, 32768 = 180 deg
				'Heading'	=> 'word',		# direction of forward axis : 0 = world y direction, 32768 = 180 deg
				'AngVel'	=> 'short',		# signed, rate of change of heading : (16384 = 360 deg/s)
			)
		);
		# Packets
		$this->packet = array(
			ISP_ISI	=> array(
				'Size'			=> 'byte',		# 44
				'Type'			=> 'byte',		# ISP_ISI
				'ReqI'			=> 'byte',		# If non-zero LFS will send an ISP_VER packet
				'Zero'			=> 'byte',		# 0

				'UDPPort'		=> 'word',		# Port for UDP replies from LFS (0 to 65535)
				'Flags'			=> 'word',		# Bit flags for options (see defines.php > ISP_ISI)

				'Sp0'			=> 'byte',		# 0
				'Prefix'		=> 'byte',		# Special host message prefix character
				'Interval'		=> 'word',		# Time in ms between NLP or MCI (0 = none)

				'Admin'			=> '16char',	# Admin password (if set in LFS)
				'IName'			=> '16char',	# A short name for your program
			),
			ISP_TINY	=> array(
				'Size'			=> 'byte',		# always 4
				'Type'			=> 'byte',		# always ISP_TINY
				'ReqI'			=> 'byte',		# 0 unless it is an info request or a reply to an info request
				'SubT'			=> 'byte',		# subtype, from TINY_ enumeration (e.g. TINY_RACE_END)
			),
			ISP_SMALL	=> array(
				'Size'			=> 'byte',		# always 8
				'Type'			=> 'byte',		# always ISP_SMALL
				'ReqI'			=> 'byte',		# 0 unless it is an info request or a reply to an info request
				'SubT'			=> 'byte',		# subtype, from SMALL_ enumeration (e.g. SMALL_SSP)

				'UVal'			=> 'unsigned',	# value (e.g. for SMALL_SSP this would be the OutSim packet rate)
			),
			ISP_VER	=> array(
				'Size'			=> 'byte',		# 20
				'Type'			=> 'byte',		# ISP_VERSION
				'ReqI'			=> 'byte',		# ReqI as received in the request packet
				'Zero'			=> 'byte',		# 0

				'Version'		=> '8char',		# LFS version, e.g. 0.5Z10
				'Product'		=> '6char',		# Product : DEMO, S1, S2 or S3
				'InSimVer'		=> 'word',		# InSim Version : increased when InSim packets change
			),
			ISP_STA	=> array(
				'Size'			=> 'byte',		# 28
				'Type'			=> 'byte',		# ISP_STA
				'ReqI'			=> 'byte',		# ReqI if replying to a request packet
				'Zero'			=> 'byte',		# 0

				'ReplaySpeed'	=> 'float',		# 4-byte float - 1.0 is normal speed

				'Flags'			=> 'byte',		# ISS state flags (see defines.php > ISP_STA)
				'InGameCam'		=> 'byte',		# Which type of camera is selected (see defines.php > ISP_STA)
				'ViewPLID'		=> 'byte',		# Unique ID of viewed player (0 = none)

				'NumP'			=> 'byte',		# Number of players in race
				'NumConns'		=> 'byte',		# Number of connections including host
				'NumFinished'	=> 'byte',		# Number finished or qualified
				'RaceInProg'	=> 'byte',		# 0 - no race / 1 - race / 2 - qualifying

				'QualMins'		=> 'byte',		# 
				'RaceLaps'		=> 'byte',		# see "RaceLaps" near the top of this document
				'Spare2'		=> 'byte',		# 0
				'Spare3'		=> 'byte',		# 0

				'Track'			=> '6char',		# short name for track e.g. BL1R
				'Weather'		=> 'byte',		# 0,1,2...
				'Wind'			=> 'byte',		# 0=off 1=weak 2=strong
			),
			ISP_SFP	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_SFP
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'Flag'			=> 'word',		# the state to set
				'OffOn'			=> 'byte',		# 0 = off / 1 = on
				'Sp3'			=> 'byte',		# spare
			),
			ISP_MOD	=> array(
				'Size'			=> 'byte',		# 20
				'Type'			=> 'byte',		# ISP_MOD
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'Bits16'		=> 'int',		# set to choose 16-bit
				'RR'			=> 'int',		# refresh rate - zero for default
				'Width'			=> 'int',		# 0 means go to window
				'Height'		=> 'int',		# 0 means go to window
			),
			ISP_MSO	=> array(
				'Size'			=> 'byte',		# 136
				'Type'			=> 'byte',		# ISP_MSO
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'UCID'			=> 'byte',		# connection's unique id (0 = host)
				'PLID'			=> 'byte',		# player's unique id (if zero, use UCID)
				'UserType'		=> 'byte',		# set if typed by a user (see User Values below)
				'TextStart'		=> 'byte',		# first character of the actual text (after player name)

				'Msg'			=> '128char',	# 
			),
			ISP_III	=> array(
				'Size'			=> 'byte',		# 72
				'Type'			=> 'byte',		# ISP_III
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'UCID'			=> 'byte',		# connection's unique id (0 = host)
				'PLID'			=> 'byte',		# player's unique id (if zero, use UCID)
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0

				'Msg'			=> '64char',	# 
			),
			ISP_MST	=> array(
				'Size'			=> 'byte',		# 68
				'Type'			=> 'byte',		# ISP_MST
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'Msg'			=> '64char',	# 
			),
			ISP_MSX	=> array(
				'Size'			=> 'byte',		# 100
				'Type'			=> 'byte',		# ISP_MSX
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'Msg'			=> '94char',	# 
			),
			ISP_MSL	=> array(
				'Size'			=> 'byte',		# 132
				'Type'			=> 'byte',		# ISP_MSL
				'ReqI'			=> 'byte',		# 0
				'Sound'			=> 'byte',		# sound effect (see Message Sounds below)

				'Msg'			=> '128char',	# last byte must be zero
			),
			ISP_MTC	=> array(
				'Size'			=> 'byte',		# 72
				'Type'			=> 'byte',		# ISP_MTC
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'UCID'			=> 'byte',		# connection's unique id (0 = host)
				'PLID'			=> 'byte',		# player's unique id (if zero, use UCID)
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0

				'Msg'			=> '64char',	# last byte must be zero
			),
			ISP_SCH	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_SCH
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'CharB'			=> 'byte',		# key to press
				'Flags'			=> 'byte',		# bit 0 : SHIFT / bit 1 : CTRL
				'Spare2'		=> 'byte',		# 0
				'Spare3'		=> 'byte',		# 0
			),
			ISP_ISM	=> array(
				'Size'			=> 'byte',		# 40
				'Type'			=> 'byte',		# ISP_ISM
				'ReqI'			=> 'byte',		# usually 0 / or if a reply : ReqI as received in the TINY_ISM
				'Zero'			=> 'byte',		# 0

				'Host'			=> 'byte',		# 0 = guest / 1 = host
				'Sp1'			=> 'byte',		# 0
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0

				'HName'			=> '32char',	# the name of the host joined or started
			),
			ISP_VTN	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_VTN
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'UCID'			=> 'byte',		# connection's unique id
				'Action'		=> 'byte',		# VOTE_X (Vote Action as defined above)
				'Spare2'		=> 'byte',		# 0
				'Spare3'		=> 'byte',		# 0
			),
			ISP_RST	=> array(
				'Size'			=> 'byte',		# 28
				'Type'			=> 'byte',		# ISP_RST
				'ReqI'			=> 'byte',		# 0 unless this is a reply to an TINY_RST request
				'Zero'			=> 'byte',		# 0

				'RaceLaps'		=> 'byte',		# 0 if qualifying
				'QualMins'		=> 'byte',		# 0 if race
				'NumP'			=> 'byte',		# number of players in race
				'Spare'			=> 'byte',		# 0

				'Track'			=> '6char',		# short track name
				'Weather'		=> 'byte',		# 
				'Wind'			=> 'byte',		# 

				'Flags'			=> 'word',		# race flags (must pit, can reset, etc - see below)
				'NumNodes'		=> 'word',		# total number of nodes in the path
				'Finish'		=> 'word',		# node index - finish line
				'Split1'		=> 'word',		# node index - split 1
				'Split2'		=> 'word',		# node index - split 2
				'Split3'		=> 'word',		# node index - split 3
			),
			ISP_NCN	=> array(
				'Size'			=> 'byte',		# 56
				'Type'			=> 'byte',		# ISP_NCN
				'ReqI'			=> 'byte',		# 0 unless this is a reply to an TINY_RST request
				'Zero'			=> 'byte',		# 0

				'UName'			=> '24char',	# username
				'PName'			=> '24char',	# nickname

				'Admin'			=> 'byte',		# 1 if admin
				'Total'			=> 'byte',		# number of connections including host
				'Flags'			=> 'byte',		# bit 2 : remote
				'Sp3'			=> 'byte',		# 0
			),
			ISP_CNL	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_CNL
				'ReqI'			=> 'byte',		# 0
				'UCID'			=> 'byte',		# unique id of the connection which left

				'Reason'		=> 'byte',		# leave reason (see below)
				'Total'			=> 'byte',		# number of connections including host
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0
			),
			ISP_CPR	=> array(
				'Size'			=> 'byte',		# 36
				'Type'			=> 'byte',		# ISP_CPR
				'ReqI'			=> 'byte',		# 0
				'UCID'			=> 'byte',		# unique id of the connection

				'PName'			=> '24char',	# new name
				'Plate'			=> '8char',		# number plate - NO ZERO AT END!
			),
			ISP_NPL	=> array(
				'Size'			=> 'byte',		# 76
				'Type'			=> 'byte',		# ISP_NPL
				'ReqI'			=> 'byte',		# 0 unless this is a reply to an TINY_NPL request
				'PLID'			=> 'byte',		# player's newly assigned unique id

				'UCID'			=> 'byte',		# connection's unique id
				'PType'			=> 'byte',		# bit 0 : female / bit 1 : AI / bit 2 : remote
				'Flags'			=> 'word',		# player flags

				'PName'			=> '24char',	# nickname
				'Plate'			=> '8char',		# number plate - NO ZERO AT END!

				'CName'			=> '4char',		# car name
				'SName'			=> '16char',	# skin name - MAX_CAR_TEX_NAME
				'Tyres'			=> '4byte',		# compounds (4 byte order : rear L, rear R, front L, front R)

				'H_Mass'		=> 'byte',		# added mass (kg)
				'H_TRes'		=> 'byte',		# intake restriction
				'Model'			=> 'byte',		# driver model
				'Pass'			=> 'byte',		# passengers byte

				'Spare'			=> 'int',		# 0

				'SetF'			=> 'byte',		# setup flags (see below)
				'NumP'			=> 'byte',		# number in race (same when leaving pits, 1 more if new)
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0
			),
			ISP_PLP	=> array(
				'Size'			=> 'byte',		# 4
				'Type'			=> 'byte',		# ISP_PLP
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id
			),
			ISP_PLL	=> array(
				'Size'			=> 'byte',		# 4
				'Type'			=> 'byte',		# ISP_PLL
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id
			),
			ISP_CRS	=> array(
				'Size'			=> 'byte',		# 4
				'Type'			=> 'byte',		# ISP_CRS
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id
			),
			ISP_LAP	=> array(
				'Size'			=> 'byte',		# 20
				'Type'			=> 'byte',		# ISP_LAP
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'LTime'			=> 'unsigned',	# lap time (ms)
				'ETime'			=> 'unsigned',	# total time (ms)

				'LapsDone'		=> 'word',		# laps completed
				'Flags'			=> 'word',		# player flags

				'Sp0'			=> 'byte',		# 0
				'Penalty'		=> 'byte',		# current penalty value (see below)
				'NumStops'		=> 'byte',		# number of pit stops
				'Sp3'			=> 'byte',		# 0
			),
			ISP_SPX	=> array(
				'Size'			=> 'byte',		# 16
				'Type'			=> 'byte',		# ISP_SPX
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'STime'			=> 'unsigned',	# split time (ms)
				'ETime'			=> 'unsigned',	# total time (ms)

				'Split'			=> 'byte',		# split number 1, 2, 3
				'Penalty'		=> 'byte',		# current penalty value (see below)
				'NumStops'		=> 'byte',		# number of pit stops
				'Sp3'			=> 'byte',		# 0
			),
			ISP_PIT	=> array(
				'Size'			=> 'byte',		# 24
				'Type'			=> 'byte',		# ISP_PIT
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'LapsDone'		=> 'word',		# laps completed
				'Flags'			=> 'word',		# player flags

				'Sp0'			=> 'byte',		# 0
				'Penalty'		=> 'byte',		# current penalty value (see below)
				'NumStops'		=> 'byte',		# number of pit stops
				'Sp3'			=> 'byte',		# 0

				'Tyres'			=> '4byte',		# tyres changed (4 byte order : rear L, rear R, front L, front R)

				'Work'			=> 'unsigned',	# pit work
				'Spare'			=> 'unsigned',	# 0
			),
			ISP_PSF	=> array(
				'Size'			=> 'byte',		# 12
				'Type'			=> 'byte',		# ISP_PSF
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'STime'			=> 'unsigned',	# stop time (ms)
				'Spare'			=> 'unsigned',	# 0
			),
			ISP_PLA	=> array(
				'Size'			=> 'byte',		# 12
				'Type'			=> 'byte',		# ISP_PSF
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'Fact'			=> 'byte',		# pit lane fact (see below)
				'Sp0'			=> 'byte',		# 0
				'Sp1'			=> 'byte',		# 0
				'Sp2'			=> 'byte',		# 0
			),
			ISP_CCH	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_CCH
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'Camera'		=> 'byte',		# view identifier (see below)
				'Sp1'			=> 'byte',		# 0
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0
			),
			ISP_PEN	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_PEN
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'OldPen'		=> 'byte',		# old penalty value (see below)
				'NewPen'		=> 'byte',		# new penalty value (see below)
				'Reason'		=> 'byte',		# penalty reason (see below)
				'Sp3'			=> 'byte',		# 0
			),
			ISP_TOC	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_TOC
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'OldUCID'		=> 'byte',		# old connection's unique id
				'NewUCID'		=> 'byte',		# new connection's unique id
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0
			),
			ISP_FLG	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_FLG
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'OffOn'			=> 'byte',		# 0 = off / 1 = on
				'Flag'			=> 'byte',		# 1 = given blue / 2 = causing yellow
				'CarBehind'		=> 'byte',		# unique id of obstructed player
				'Sp3'			=> 'byte',		# 0
			),
			ISP_PFL	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_PFL
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id

				'Flags'			=> 'word',		# player flags (see below)
				'Spare'			=> 'word',		# 0
			),
			ISP_FIN	=> array(
				'Size'			=> 'byte',		# 20
				'Type'			=> 'byte',		# ISP_FIN
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id (0 = player left before result was sent)

				'TTime'			=> 'unsigned',	# race time (ms)
				'BTime'			=> 'unsigned',	# best lap (ms)

				'SpA'			=> 'byte',		# 
				'NumStops'		=> 'byte',		# number of pit stops
				'Confirm'		=> 'byte',		# confirmation flags : disqualified etc - see below
				'SpB'			=> 'byte',		# 

				'LapsDone'		=> 'word',		# laps completed
				'Flags'			=> 'word',		# player flags : help settings etc - see below
			),
			ISP_RES	=> array(
				'Size'			=> 'byte',		# 84
				'Type'			=> 'byte',		# ISP_RES
				'ReqI'			=> 'byte',		# 0 unless this is a reply to a TINY_RES request
				'PLID'			=> 'byte',		# player's unique id (0 = player left before result was sent)

				'UName'			=> '24char',	# username
				'PName'			=> '24char',	# nickname
				'Plate'			=> '8char',		# number plate - NO ZERO AT END!
				'CName'			=> '4char',		# skin prefix

				'TTime'			=> 'unsigned',	# race time (ms)
				'BTime'			=> 'unsigned',	# best lap (ms)

				'SpA'			=> 'byte',		# 0
				'NumStops'		=> 'byte',		# number of pit stops
				'Confirm'		=> 'byte',		# confirmation flags : disqualified etc - see below
				'SpB'			=> 'byte',		# 0

				'LapsDone'		=> 'word',	# laps completed
				'Flags'			=> 'word',		# player flags : help settings etc - see below

				'ResultNum'		=> 'byte',		# finish or qualify pos (0 = win / 255 = not added to table)
				'NumRes'		=> 'byte',		# total number of results (qualify doesn't always add a new one)
				'PSeconds'		=> 'word',		# penalty time in seconds (already included in race time)
			),
			ISP_REO	=> array(
				'Size'			=> 'byte',		# 36
				'Type'			=> 'byte',		# ISP_REO
				'ReqI'			=> 'byte',		# 0 unless this is a reply to an TINY_REO request
				'NumP'			=> 'byte',		# number of players in race

				'PLID'			=> '32byte',	# all PLIDs in new order
			),
			ISP_AXI	=> array(
				'Size'			=> 'byte',		# 40
				'Type'			=> 'byte',		# ISP_AXI
				'ReqI'			=> 'byte',		# 0 unless this is a reply to an TINY_AXI request
				'Zero'			=> 'byte',		# 0

				'AXStart'		=> 'byte',		# autocross start position
				'NumCP'			=> 'byte',		# number of checkpoints
				'NumO'			=> 'word',		# number of objects

				'LName'			=> '32char',	# the name of the layout last loaded (if loaded locally)
			),
			ISP_AXO	=> array(
				'Size'			=> 'byte',		# 4
				'Type'			=> 'byte',		# ISP_AXO
				'ReqI'			=> 'byte',		# 0
				'PLID'			=> 'byte',		# player's unique id
			),
			ISP_NPL	=> array(
				'Size'			=> 'byte',		# 4 + NumP * 6 (PLUS 2 if needed to make it a multiple of 4)
				'Type'			=> 'byte',		# ISP_NLP
				'ReqI'			=> 'byte',		# 0 unless this is a reply to an TINY_NLP request
				'NumP'			=> 'byte',		# number of players in race

				'Info'			=> '32NodeLap',	# node and lap of each player, 1 to 32 of these (NumP)
			),
			ISP_MCI	=> array(
				'Size'			=> 'byte',		# 4 + NumC * 28
				'Type'			=> 'byte',		# ISP_MCI
				'ReqI'			=> 'byte',		# 0 unless this is a reply to an TINY_MCI request
				'NumC'			=> 'byte',		# number of valid CompCar structs in this packet

				'Info'			=> '8CompCar'	# car info for each player, 1 to 8 of these (NumC)
			),
			ISP_SCC	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_SCC
				'ReqI'			=> 'byte',		# 0
				'Zero'			=> 'byte',		# 0

				'ViewPLID'		=> 'byte',		# UniqueID of player to view
				'InGameCam'		=> 'byte',		# InGameCam (as reported in StatePack)
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0
			),
			ISP_CPP	=> array(
				'Size'			=> 'byte',		# 32
				'Type'			=> 'byte',		# ISP_CPP
				'ReqI'			=> 'byte',		# instruction : 0 / or reply : ReqI as received in the TINY_SCP
				'Zero'			=> 'byte',		# 0

				'Pos'			=> 'Vec',		# Position vector

				'H'				=> 'word',		# heading - 0 points along Y axis
				'P'				=> 'word',		# pitch   - 0 means looking at horizon
				'R'				=> 'word',		# roll    - 0 means no roll

				'ViewPLID'		=> 'byte',		# Unique ID of viewed player (0 = none)
				'InGameCam'		=> 'byte',		# InGameCam (as reported in StatePack)

				'FOV'			=> 'float',		# 4-byte float : FOV in degrees

				'Time'			=> 'word',		# Time to get there (0 means instant + reset)
				'Flags'			=> 'word',		# ISS state flags (see below)
			),
			ISP_RIP	=> array(
				'Size'			=> 'byte',		# 80
				'Type'			=> 'byte',		# ISP_RIP
				'ReqI'			=> 'byte',		# request : non-zero / reply : same value returned
				'Error'			=> 'byte',		# 0 or 1 = OK / other values are listed below

				'MPR'			=> 'byte',		# 0 = SPR / 1 = MPR
				'Paused'		=> 'byte',		# request : pause on arrival / reply : paused state
				'Options'		=> 'byte',		# various options - see below
				'Sp3'			=> 'byte',		# 0

				'CTime'			=> 'unsigned',	# (hundredths) request : destination / reply : position
				'TTime'			=> 'unsigned',	# (hundredths) request : zero / reply : replay length

				'RName'			=> '64char',	# zero or replay name - last byte must be zero
			),
			ISP_SSH	=> array(
				'Size'			=> 'byte',		# 40
				'Type'			=> 'byte',		# ISP_SSH
				'ReqI'			=> 'byte',		# request : non-zero / reply : same value returned
				'Error'			=> 'byte',		# 0 = OK / other values are listed below

				'Sp0'			=> 'byte',		# 0
				'Sp1'			=> 'byte',		# 0
				'Sp2'			=> 'byte',		# 0
				'Sp3'			=> 'byte',		# 0

				'BMP'			=> '32char',	# name of screenshot file - last byte must be zero
			),
			ISP_BFN	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_BFN
				'ReqI'			=> 'byte',		# 0
				'SubT'			=> 'byte',		# subtype, from BFN_ enumeration (see below)

				'UCID'			=> 'byte',		# connection to send to or from (0 = local / 255 = all)
				'ClickID'		=> 'byte',		# ID of button to delete (if SubT is BFN_DEL_BTN)
				'Inst'			=> 'byte',		# used internally by InSim
				'Sp3'			=> 'byte',		# 0
			),
			ISP_BTN	=> array(
				'Size'			=> 'byte',		# 12 + TEXT_SIZE (a multiple of 4)
				'Type'			=> 'byte',		# ISP_BTN
				'ReqI'			=> 'byte',		# non-zero (returned in ISP_BTC and ISP_BTT packets)
				'UCID'			=> 'byte',		# connection to display the button (0 = local / 255 = all)

				'ClickID'		=> 'byte',		# button ID (0 to 239)
				'Inst'			=> 'byte',		# some extra flags - see below
				'BStyle'		=> 'byte',		# button style flags - see below
				'TypeIn'		=> 'byte',		# max chars to type in - see below

				'L'				=> 'byte',		# left   : 0 - 200
				'T'				=> 'byte',		# top    : 0 - 200
				'W'				=> 'byte',		# width  : 0 - 200
				'H'				=> 'byte',		# height : 0 - 200

				'Text'			=> '240char',	# 0 to 240 characters of text
			),
			ISP_BTC	=> array(
				'Size'			=> 'byte',		# 8
				'Type'			=> 'byte',		# ISP_BTC
				'ReqI'			=> 'byte',		# ReqI as received in the ISP_BTN
				'UCID'			=> 'byte',		# connection that clicked the button (zero if local)

				'ClickID'		=> 'byte',		# button identifier originally sent in ISP_BTN
				'Inst'			=> 'byte',		# used internally by InSim
				'CFlags'		=> 'byte',		# button click flags - see below
				'Sp3'			=> 'byte',		# 0
			),
			ISP_BTT	=> array(
				'Size'			=> 'byte',		# 104
				'Type'			=> 'byte',		# ISP_BTT
				'ReqI'			=> 'byte',		# ReqI as received in the ISP_BTN
				'UCID'			=> 'byte',		# connection that typed into the button (zero if local)

				'ClickID'		=> 'byte',		# button identifier originally sent in ISP_BTN
				'Inst'			=> 'byte',		# used internally by InSim
				'TypeIn'		=> 'byte',		# from original button specification
				'Sp3'			=> 'byte',		# 0

				'Text'			=> '96char',	# typed text, zero to TypeIn specified in ISP_BTN
			)
		);
		$this->main();
	}
	function __destruct() {
		
	}
}

?>