#include "clog.h"
#include "cmgr.h"

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cLog, cPane)
  EVT_SIZE(cLog::OnSize)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------

cLog::cLog(wxWindow* parent)
: cPane(parent)
{
  m_LogText = new wxTextCtrl(this, wxID_ANY, wxEmptyString,
    wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE | wxTE_DONTWRAP | wxTE_READONLY );
  m_LogText->SetBackgroundColour(GetBackgroundColour());

  SetMinSize(wxSize(500, 150));

  m_TopSizer = new wxBoxSizer(wxVERTICAL);
  m_TopSizer->Add(m_LogText, wxSizerFlags(1).Expand().Proportion(1));
  SetSizer(m_TopSizer);

  RedirectEvents(m_LogText, this, false, true); // redirect escape-key events to parent
  RedirectEvents(m_LogText, NULL, true, false); // redirect mouse-wheel events to window-at-pointer

  // redirect log messages to this window
  m_OldLogTarget = wxLog::SetActiveTarget(new wxLogTextCtrl(m_LogText));
}

//-----------------------------------------------------------------------------

cLog::~cLog()
{
  // restore previous log target
  delete wxLog::SetActiveTarget(m_OldLogTarget);
}

//-----------------------------------------------------------------------------
// Append a message to the log
// - msg = message contents
// - error = treat this message as an error notification

void cLog::AddMessage(const wxString& msg, bool error)
{
  if (error) wxBell();

  m_LogText->AppendText(msg);
  m_LogText->AppendText(_T("\n"));
}

//-----------------------------------------------------------------------------

void cLog::OnSize(wxSizeEvent& event)
{
  Layout();
  event.Skip();
}
