#ifndef _CCAR_H_
#define _CCAR_H_

#include "global.h"

#define MAX_GEAR_RATIOS 7

//-----------------------------------------------------------------------------
// Contains static data about the car

class cCar
{
private:
  static wxString s_DefaultCarCodes[];
  static wxArrayString s_CarCodes;
  static wxString s_TyreTypeNames[];

public:
  wxString m_Name;          // car name
  float m_AntiRoll_Front;   // front anti-roll bar (N/m)
  float m_AntiRoll_Rear;    // rear anti-roll bar (N/m)
  float m_FinalDrive;       // final drive ratio
  wxInt8 m_GearCount;       // number of forward gears
  float m_GearRatio[MAX_GEAR_RATIOS]; // forward gear ratios

  // data for each wheel
  // 0 = front left, 1 = front right, 2 = rear left, 3 = rear right
  float m_WheelX[4];        // X position (relative to reference point)
  float m_WheelY[4];        // Y position (relative to reference point)
  float m_Radius[4];        // wheel radius (unloaded)
  float m_MaxDeflect[4];    // wheel suspension travel
  wxInt8 m_TyreType[4];     // tyre type
  float m_Spring[4];        // wheel spring constant (N/m)
  float m_Damp_Bump[4];     // bump damping (Ns/m)
  float m_Damp_Rebound[4];  // rebound damping (Ns/m)
  float m_Brake[4];         // max brake torque (Nm)

  cCar();
  virtual ~cCar();

  static void InitCars(const wxString& configFile);

  static wxString Name2Code(const wxString& name);
  static void GetCodes(wxArrayString& codes);
  static void GetNames(wxArrayString& names);

  static wxString TyreCode2Name(int numbercode);

  float GetLength() const { return abs(m_WheelY[0] - m_WheelY[3]); }
  float GetWidth() const { return abs(m_WheelX[0] - m_WheelX[3]); }
};

#endif
