#include "ccsvdlg.h"
#include <wx/config.h>

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cCsvDlg, wxDialog)
  EVT_BUTTON(wxID_ANY, cCsvDlg::OnButton)
  EVT_CHECKBOX(wxID_ANY, cCsvDlg::OnCheckBox)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------
// - parent = parent window

cCsvDlg::cCsvDlg(wxWindow* parent)
: wxDialog(parent, -1, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE)
{
  // default settings
  // TODO: read from default locale
  m_DecSep = _T('.');
  m_FieldWrap = wxEmptyString;
  m_HeaderLine = true;

  // controls
  wxArrayString choices;
  m_HeaderLineCheck = new wxCheckBox(this, ID_CTRL_CHECK_HEADERLINE, wxEmptyString);
  wxCheckBox* decSepCheck = new wxCheckBox(this, wxID_ANY, wxEmptyString); // dummy checkbox (always checked & disabled)
  decSepCheck->SetValue(true);
  decSepCheck->Enable(false);
  m_DecSepText = new wxStaticText(this, ID_TXT_DECSEP, wxEmptyString);
  choices.Add(_T(','));
  choices.Add(_T('.'));
  m_DecSepChoice  = new wxChoice(this, ID_CTRL_CHOICE_DECSEP, wxDefaultPosition, wxDefaultSize, choices);
  m_FieldWrapCheck = new wxCheckBox(this, ID_CTRL_CHECK_FIELDWRAP, wxEmptyString);
  choices.Clear();
  choices.Add(_T('\"'));
  choices.Add(_T('\''));
  m_FieldWrapChoice = new wxChoice(this, ID_CTRL_CHOICE_FIELDWRAP, wxDefaultPosition, wxDefaultSize, choices);

  // buttons
  m_CancelBtn = new wxButton(this, wxID_CANCEL, wxEmptyString);
  m_OkBtn = new wxButton(this, wxID_OK, wxEmptyString);
  m_OkBtn->SetDefault();

  // populate sizers
  m_DecSepSizer = new wxBoxSizer(wxHORIZONTAL);
  m_DecSepSizer->Add(decSepCheck, wxSizerFlags(1).Proportion(0).Center());
  m_DecSepSizer->AddSpacer(BASE_MARGIN);
  m_DecSepSizer->Add(m_DecSepText, wxSizerFlags(1).Proportion(0).Center());
  m_DecSepSizer->AddStretchSpacer();
  m_DecSepSizer->Add(m_DecSepChoice, wxSizerFlags(1).Proportion(0).Center());

  m_FieldWrapSizer = new wxBoxSizer(wxHORIZONTAL);
  m_FieldWrapSizer->Add(m_FieldWrapCheck, wxSizerFlags(1).Proportion(0).Center());
  m_FieldWrapSizer->AddStretchSpacer();
  m_FieldWrapSizer->Add(m_FieldWrapChoice, wxSizerFlags(1).Proportion(0).Center());

  m_ButtonSizer = new wxBoxSizer(wxHORIZONTAL);
  m_ButtonSizer->AddStretchSpacer();
  m_ButtonSizer->Add(m_CancelBtn);
  m_ButtonSizer->AddSpacer(BASE_MARGIN);
  m_ButtonSizer->Add(m_OkBtn);

  m_TopSizer = new wxBoxSizer(wxVERTICAL);
  m_TopSizer->Add(m_HeaderLineCheck, wxSizerFlags(1).Expand().Proportion(0).Border(wxALL, BASE_MARGIN));
  m_TopSizer->Add(m_DecSepSizer, wxSizerFlags(1).Expand().Proportion(0).Border(wxALL, BASE_MARGIN));
  m_TopSizer->Add(m_FieldWrapSizer, wxSizerFlags(1).Expand().Proportion(0).Border(wxALL, BASE_MARGIN));
  m_TopSizer->AddSpacer(BASE_MARGIN);
  m_TopSizer->Add(m_ButtonSizer, wxSizerFlags(1).Expand().Proportion(0).Border(wxALL, BASE_MARGIN));

  TranslateTexts();
  SetSizer(m_TopSizer);
  SetSize(m_TopSizer->ComputeFittingWindowSize(this));
}

//-----------------------------------------------------------------------------

cCsvDlg::~cCsvDlg()
{
}

//-----------------------------------------------------------------------------

void cCsvDlg::OnButton(wxCommandEvent& event)
{
  switch (event.GetId()) {
    case ID_CTRL_FD_DELETE :
      break;

    case wxID_OK :
      DoEnter();
      break;

    default :
      event.Skip();
      return;
  }
}

//-----------------------------------------------------------------------------
// Prepare things and show the (modal) dialog

int cCsvDlg::DoShowModal()
{
  // set controls
  m_DecSepChoice->SetStringSelection(m_DecSep);
  if (m_FieldWrap.IsEmpty()) {
    m_HeaderLineCheck->SetValue(false);
    m_FieldWrapChoice->SetSelection(0);
  }
  else {
    m_HeaderLineCheck->SetValue(true);
    m_FieldWrapChoice->SetStringSelection(m_FieldWrap);
  }
  m_HeaderLineCheck->SetValue(m_HeaderLine);
  EnableButtons();

  CentreOnParent();
  return ShowModal();
}

//-----------------------------------------------------------------------------

void cCsvDlg::DoEnter()
{
  // fetch input
  m_DecSep = m_DecSepChoice->GetStringSelection();
  if (m_FieldWrapCheck->GetValue()) {
    m_FieldWrap = m_FieldWrapChoice->GetStringSelection();
  }
  else {
    m_FieldWrap = wxEmptyString;
  }
  m_HeaderLine = m_HeaderLineCheck->GetValue();

  if (IsModal()) EndModal(wxID_OK);
}

//-----------------------------------------------------------------------------
// Enable or disable the controls

void cCsvDlg::EnableButtons()
{
  m_FieldWrapChoice->Enable(m_FieldWrapCheck->GetValue());
}

//-----------------------------------------------------------------------------
// Loading and saving the configuration settings

void cCsvDlg::LoadConfig(wxRegConfig* config, const wxString& key)
{
  config->Read(key + _T("/decimal_separator"), &m_DecSep);
  config->Read(key + _T("/field_separator"), &m_FieldWrap);
  config->Read(key + _T("/header_line"), &m_HeaderLine);
}


void cCsvDlg::SaveConfig(wxRegConfig* config, const wxString& key)
{
  config->Write(key + _T("/decimal_separator"), m_DecSep);
  config->Write(key + _T("/field_separator"), m_FieldWrap);
  config->Write(key + _T("/header_line"), m_HeaderLine);
}

//-----------------------------------------------------------------------------
//

void cCsvDlg::TranslateTexts()
{
  SetTitle(_TT(ID_CAPTION_CSVDIALOG, "CSV Export settings"));

  // control labels
  m_DecSepText->SetLabel(_TT(ID_TXT_DECSEP, "Decimal separator"));
  m_FieldWrapCheck->SetLabel(_TT(ID_CTRL_CHECK_FIELDWRAP, "Wrap column values in"));
  m_HeaderLineCheck->SetLabel(_TT(ID_CTRL_CHECK_HEADERLINE, "First line contains column names"));
}
