#include "ccar.h"
#include <wx/tokenzr.h>

//-----------------------------------------------------------------------------
// Static members

// array to map display name(s) to a car code
// syntax: <primary_name> ':' [<alternate_name> ':']* <code>

wxString cCar::s_DefaultCarCodes[] = {
 _T("XF GTI:XFG"),
 _T("XR GT:XRG"),
 _T("XR GT Turbo:XRT"),
 _T("RB4 GT:RB4"),
 _T("FXO Turbo:FXO"),
 _T("LX4:LX4"),
 _T("LX6:LX6"),
 _T("MRT5:MRT"),
 _T("UF 1000:UF1"),
 _T("RACEABOUT:RA:RAC"),
 _T("FZ50:FZ5"),
 _T("XF GTR:XFR"),
 _T("UF GTR:UFR"),
 _T("Formula XR:FOX"),
 _T("Formula V8:FO8"),
 _T("BMW Sauber:BMW Sauber F1.06:BF1"),
 _T("FXO GTR:FXR"),
 _T("XR GTR:XRR"),
 _T("FZ50 GTR:FZR"),
 _T("Formula BMW FB02:FBM")
};

wxString cCar::s_TyreTypeNames[] = {
  _T("R1"),
  _T("R2"),
  _T("R3"),
  _T("R4"),
  _T("ROAD SUPER"),
  _T("ROAD NORMAL"),
  _T("HYBRID"),
  _T("KNOBBLY")
};

wxArrayString cCar::s_CarCodes;

//-----------------------------------------------------------------------------

cCar::cCar()
{
}

//-----------------------------------------------------------------------------

cCar::~cCar()
{
}

//-----------------------------------------------------------------------------
// Initialise static data

void cCar::InitCars(const wxString& configFile)
{
  wxASSERT(s_CarCodes.IsEmpty());

  if (!::ReadConfigFile(configFile, s_CarCodes)) {
    // load from file failed; read hard-coded data
    for (int i = 0; i < sizeof(s_DefaultCarCodes) / sizeof(wxString); i++) {
      s_CarCodes.Add(s_DefaultCarCodes[i]);
    }
  }
}

//-----------------------------------------------------------------------------
// Convert the full car name to the 3-letter code
// - name = car name

wxString cCar::Name2Code(const wxString& name)
{
  wxASSERT(!s_CarCodes.IsEmpty());

  // search the list
  for (size_t i = 0; i < s_CarCodes.GetCount(); i++) {
    wxArrayString names = wxStringTokenize(s_CarCodes[i], _T(":"));
    wxASSERT(names.GetCount() >= 2);

    for (size_t j = 0; j < names.GetCount() - 1; j++) {
      if (names[j].CmpNoCase(name) != 0) continue; // different name

      // found it
      return names[names.GetCount() - 1];
    }
  }

  // not found
  wxFAIL;
  return wxEmptyString;
}

//-----------------------------------------------------------------------------
// Get the list of codes
// - codes = list that will be filled with the codes

void cCar::GetCodes(wxArrayString& codes)
{
  wxASSERT(!s_CarCodes.IsEmpty());
  codes.Empty();
  for (size_t i = 0; i < s_CarCodes.GetCount(); i++) {
    codes.Add(s_CarCodes[i].AfterLast(':'));
  }
  codes.Sort();
}

//-----------------------------------------------------------------------------
// Get the list of names (<code> - <primary_name>)
// - names = list that will be filled with the names

void cCar::GetNames(wxArrayString& names)
{
  wxASSERT(!s_CarCodes.IsEmpty());
  names.Empty();
  for (size_t i = 0; i < s_CarCodes.GetCount(); i++) {
    names.Add(s_CarCodes[i].AfterLast(':') + _T(" - ") + s_CarCodes[i].BeforeFirst(':'));
  }
  names.Sort();
}

//-----------------------------------------------------------------------------
// Convert a tyre number to its display name
// - index = tyre number (see http://www.lfs.net/?page=RAF)

wxString cCar::TyreCode2Name(int index)
{
  int count = sizeof(s_TyreTypeNames) / sizeof(wxString);
  if ((index < 0) || (index >= count)) return wxEmptyString;
  return s_TyreTypeNames[index];
}
