#ifndef _CLOG_H_
#define _CLOG_H_

#include "global.h"
#include "cpane.h"
#include <wx/textctrl.h>
#include <wx/sizer.h>

class wxLog;

//-----------------------------------------------------------------------------
// The pane with the message log (errors and debug messages)

class cLog : public cPane
{
private:
  wxTextCtrl* m_LogText;        // the logged messages
  wxBoxSizer* m_TopSizer;

  wxLog* m_OldLogTarget;        // the previous log target

  void OnSize(wxSizeEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cLog(wxWindow* parent);
  virtual ~cLog();

  void AddMessage(const wxString& msg, bool error = false);
  void Clear() { m_LogText->Clear(); }

  virtual void TranslateTexts() {}
};

#endif
