#ifndef _CGRAPHTOOLS_H_
#define _CGRAPHTOOLS_H_

#include "global.h"
#include "cgraph.h"
#include "ccarstate.h"
#include <wx/window.h>
#include <wx/button.h>
#include <wx/sizer.h>

class cGraphView;

//-----------------------------------------------------------------------------
// A toolbar on a graph

class cGraphTools : public wxWindow
{
private:
  static wxArrayString s_LogTypeNames;
  static wxArrayString s_WheelTypeNames;

  cGraphView* m_Parent;      // the parent window
  wxButton* m_FitButton;     // "Fit" button
  wxButton* m_CloseButton;   // "Close" button

  void OnButtonClose(wxCommandEvent& event);
  void OnButtonFit(wxCommandEvent& event);
  void OnSize(wxSizeEvent& event);

  DECLARE_EVENT_TABLE()

protected:
  cGraph* m_Graph;           // the graph to which it belongs
  wxBoxSizer* m_TopSizer;

  virtual void DoEnableControls() = 0;

  static void CacheLogTypeNames();
  wxChoice* CreateLogtypeControl(wxWindowID id);
  void SetLogtypeStrings(wxChoice* control);
  bool SetLogtypeSelection(wxChoice* control, int log);
  int GetLogtypeSelection(wxChoice* control);

  static void CacheWheelTypeNames();
  wxChoice* CreateWheeltypeControl(wxWindowID id);
  void SetWheeltypeStrings(wxChoice* control);
  bool SetWheeltypeSelection(wxChoice* control, int wheel);
  int GetWheeltypeSelection(wxChoice* control);

  int FillLapSelection(wxChoice* control, cLap* lap);
  cLap* GetLapSelection(wxChoice* control);

public:
  ENABLE_OBJCHECKER

  cGraphTools(cGraphView* parent, cGraph* graph);
  virtual ~cGraphTools();

  virtual void UpdateAll() = 0;
  void EnableControls();

  static void ResetTexts();
  virtual void TranslateTexts();

  void GraphPositionIs(int index, int total);
};

#endif
