#ifndef _CEVENTREDIRECTOR_H_
#define _CEVENTREDIRECTOR_H_

#include "global.h"
#include <wx/window.h>
#include <wx/dynarray.h>

class cEventRedirectorHandler;
WX_DEFINE_ARRAY(cEventRedirectorHandler*, cEventRedirectorHandlerPtrArray);

//-----------------------------------------------------------------------------
// A mixin class to redirect mouse-wheel and keypress events to other windows

class cEventRedirector
{
private:
  cEventRedirectorHandlerPtrArray m_Handlers;

protected:
  void RedirectEvents(wxWindow* source, wxWindow* target, bool wheel, bool esc);

public:
  cEventRedirector();
  virtual ~cEventRedirector();
};

//-----------------------------------------------------------------------------
// The event handler to redirect the events

class cEventRedirectorHandler : public wxEvtHandler
{
private:
  wxWindow* m_Source;
  wxWindow* m_Target;
  bool m_RedirectMouseWheel;
  bool m_RedirectEscKey;

  void OnKey(wxKeyEvent& event);
  void OnMouseWheel(wxMouseEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cEventRedirectorHandler(wxWindow* source, wxWindow* target, bool wheel, bool esc);
  virtual ~cEventRedirectorHandler();
};

#endif
