#include "ceventredirector.h"

//-----------------------------------------------------------------------------
//

cEventRedirector::cEventRedirector()
{
}


cEventRedirector::~cEventRedirector()
{
  // remove event handlers (in reverse order!!)
  for (int i = m_Handlers.GetCount() - 1; i > 0; i--) {
    delete m_Handlers[i];
  }
  m_Handlers.Clear();
}

//-----------------------------------------------------------------------------
// Add an event redirector

void cEventRedirector::RedirectEvents(wxWindow* source, wxWindow* target, bool wheel, bool esc)
{
  m_Handlers.Add(new cEventRedirectorHandler(source, target, wheel, esc));
}

//-----------------------------------------------------------------------------
// Event table

BEGIN_EVENT_TABLE(cEventRedirectorHandler, wxEvtHandler)
  EVT_KEY_DOWN(cEventRedirectorHandler::OnKey)
  EVT_MOUSEWHEEL(cEventRedirectorHandler::OnMouseWheel)
END_EVENT_TABLE()

//-----------------------------------------------------------------------------
// - source = the window that is the source of events
// - target = the window that must get the redirected events (may be NULL)

cEventRedirectorHandler::cEventRedirectorHandler(wxWindow* source, wxWindow* target, bool wheel, bool esc)
{
  wxASSERT(source != NULL);
  wxASSERT(source != target);
  wxASSERT((!esc) || (target != NULL)); // must have target to redirect key-events to
  m_Source = source;
  m_Target = target;
  m_RedirectMouseWheel = wheel;
  m_RedirectEscKey = esc;

  m_Source->PushEventHandler(this); // attach event handler to source window
}

//-----------------------------------------------------------------------------

cEventRedirectorHandler::~cEventRedirectorHandler()
{
  // detach from source window
  m_Source->PopEventHandler();
}

//-----------------------------------------------------------------------------

void cEventRedirectorHandler::OnMouseWheel(wxMouseEvent& event)
{
  if (!m_RedirectMouseWheel) {
    event.Skip();
    return;
  }

  if ((wxWindow::FindFocus() == m_Source) && (event.GetId() == m_Source->GetId())) {
    // this is an "original" event (= not passed or redirected)
    wxPoint pt;
    wxWindow* wap = wxFindWindowAtPointer(pt);
    if ((wap != NULL) && (wap != m_Source)) {
      // pass event to the window under the pointer
      // wxLogDebug(_T("%d passes wheel event(%d) to %d"), m_Source->GetId(), event.GetId(), wap->GetId());
      wap->GetEventHandler()->ProcessEvent(event);
      event.Skip(false); // stop further processing
      return;
    }
  }

  if (m_Target != NULL) {
    // redirect event to target window
    // wxLogDebug(_T("%d redirects wheel event(%d) to %d"), m_Source->GetId(), event.GetId(), m_Target->GetId());
    event.SetId(m_Source->GetId()); // mark it as "non-original, to prevent lnfinite redirection
    m_Target->GetEventHandler()->ProcessEvent(event);
    event.Skip(false); // stop further processing
    return;
  }

  // wxLogDebug(_T("%d keeps event(%d)"), m_Source->GetId(), event.GetId());
  event.Skip();
}

//-----------------------------------------------------------------------------

void cEventRedirectorHandler::OnKey(wxKeyEvent& event)
{
  if (!m_RedirectEscKey) {
    event.Skip();
    return;
  }

  if ((m_Target != NULL) && (event.GetKeyCode() == WXK_ESCAPE)) {
    // only pass the Escape key
    // wxLogDebug(_T("%d redirects escape-key event(%d) to %d"), m_Source->GetId(), event.GetId(), m_Target->GetId());
    m_Target->GetEventHandler()->ProcessEvent(event);
  }
  else {
    event.Skip();
  }
}
