#ifndef _CCURVE_Y_H_
#define _CCURVE_Y_H_

#include "global.h"
#include "ccurve.h"
#include "ccarstate.h"
#include "clap.h"
#include <wx/dc.h>

class cGraph;

//-----------------------------------------------------------------------------
// A curve in an Y-graph

class cCurveY
: public cCurve
{
private:
  cLap* m_DeltaLap;    // delta-lap (i.e. plot differences with data from this lap)
  int m_Logtype;       // type of log-data to be shown
  int m_Wheel;         // index of the wheel for which the data must be shown

  size_t m_NextState;  // index of next state to be plotted
  float m_LastState;   // distance_in_lap of last state to be plotted
  size_t m_StateStep;  // step size for going through the states when plotting
  bool m_Finished;     // have we finished plotting?

public:
  cCurveY(cLap* lap);
  virtual ~cCurveY();

  // Override X size of bounding box: always the full track length
  virtual float GetMinX() { return 0.0f; }
  virtual float GetMaxX() { return m_Lap->GetTrackLength(); }

  virtual void Rewind(float start, float end, size_t maxPoints);
  virtual bool GetNextPoint(float& x, float& y);
  virtual bool GetValueAt(float distance, float& x, float& y);

  void SetLogtype(int log, int wheel);
  void SetDeltaLap(cLap* lap);
};

#endif
