#ifndef _CURL_H_
#define _CURL_H_

#include "global.h"
#include <wx/url.h>

class wxOutputStream;

//-----------------------------------------------------------------------------
// Base class to read data from an URL

class cUrl
{
private:
  wxString m_UrlName;     // the URL string
  wxURL m_URL;            // the wxURL object
  wxString m_Error;       // the error description

  bool ReadData(wxOutputStream* outStream);
  bool ReportError(const wxString& msg);

public:
  cUrl(const wxString& url);
  virtual ~cUrl();

  inline const wxString& GetUrlName() const { return m_UrlName; }
  inline const wxString& GetError() const { return m_Error; }

  bool ReadToString(wxString* data);
  bool ReadToFile(const wxString& fileName);
};

//-----------------------------------------------------------------------------

#endif
