#ifndef _CTRACK_H_
#define _CTRACK_H_

#include "global.h"
#include <wx/file.h>

//-----------------------------------------------------------------------------
// Contains data about the tracks

class cTrack
{
private:
  static wxString s_DefaultTrackCodes[];
  static wxArrayString s_TrackCodes;      // for converting track+config name to track code
  static wxString s_DefaultVenueCodes[];
  static wxArrayString s_VenueCodes;      // for converting venue code to LFSW venue number

  // not intended to be instantiated (all members are static), so ctor & dtor are private
  cTrack();
  virtual ~cTrack();

public:
  static void InitTracks(const wxString& configFile);
  static void InitVenues(const wxString& configFile);

  static wxString Name2Code(wxString& name, wxString& config);
  static wxString Name2Venue(const wxString& name);

  static wxString Code2Lfsw(const wxString& code);

  static void GetCodes(wxArrayString& codes);
  static void GetNames(wxArrayString& names);
};

#endif
