#ifndef _CPLAYBACK_H_
#define _CPLAYBACK_H_

#include "global.h"
#include "ctoolbar.h"
#include <wx/timer.h>
#include <wx/stopwatch.h>
#include <wx/stattext.h>

#define MIN_PLAYBACK_SPEED 0.125f
#define MAX_PLAYBACK_SPEED 8.0f

//-----------------------------------------------------------------------------
// Toolbar for playback of laps

class cPlayback : public cToolbar
{
private:
  wxTimer m_Timer;
  float m_Speed;             // speed factor (1.0 = normal playback)
  float m_Cursor;            // current point (time-in-lap) for playback
  wxStopWatch m_Sw;          // stopwatch to measure time between two calls of Notify()

  bool m_AutoScroll;         // automatically scroll the display?
  float m_SelStart;          // distance-in-lap where selected part of track starts
  float m_SelEnd;            // distance-in-lap where selected part of track end

  // toolbar controls
  wxStaticText* m_TimeText;  // displays the time cursor
  wxStaticText* m_SpeedText; // displays the speed

  void EnableTools();
  void ShowTime();

  void OnTimer(wxTimerEvent& event);

  DECLARE_EVENT_TABLE()

public:
  cPlayback(wxWindow* parent);
  virtual ~cPlayback();

  virtual void TranslateTexts();

  bool IsRunning() const { return m_Timer.IsRunning(); }
  void Reset();
  void Pause();
  void Resume();

  void SetSpeed(float factor);
  float GetSpeed() const { return m_Speed; }
  void Slower() { SetSpeed(0.5f * m_Speed); }
  void Faster() { SetSpeed(2.0f * m_Speed); }
  inline bool CanGoSlower() const { return (m_Speed > MIN_PLAYBACK_SPEED); }
  inline bool CanGoFaster() const { return (m_Speed < MAX_PLAYBACK_SPEED); }

  void SetAutoScroll(bool flag) { m_AutoScroll = flag; }
  inline bool GetAutoScroll() const { return m_AutoScroll; }

  virtual void UpdateAll();
  virtual void DoSetTrackCursorPos(cGraphView* view, float distance, int type);
  virtual void DoSetTrackSelection(float start, float end);

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

#endif
