#ifndef _CFILEDLG_H_
#define _CFILEDLG_H_

#include "global.h"
#include <wx/dialog.h>
#include <wx/notebook.h>
#include <wx/listctrl.h>
#include <wx/sizer.h>
#include <wx/choice.h>
#include <wx/button.h>
#include <wx/stattext.h>
#include <wx/menu.h>
#include <wx/dynarray.h>
#include <wx/checkbox.h>

class wxRegConfig;
class cFileDlgItemData;
class cPubstatDlg;

WX_DEFINE_ARRAY(cFileDlgItemData*, cFileDlgItemDataPtrArray);

//-----------------------------------------------------------------------------
// The custom "Open File" dialog

class cFileDlg : public wxDialog
{
private:
  bool m_Initialising;              // are we still initialising the object?
  wxString m_CarFilter;             // the applied car filter (empty if "all")
  wxString m_TrackFilter;           // the applied track filter (empty if "all")
  wxString m_AllString;             // the "all" entry for filters
  bool m_Adding;                    // are we adding files, or are no files loaded yet?

  wxNotebook* m_Notebook;           // notebook, containing the file lists
  wxPanel* m_Page[2];               // the notebook pages
  wxListView* m_List[2];            // the 2 lists showing the local files and the files on LFS World
  cFileDlgItemDataPtrArray m_ItemData[2];  // item data attached to the items in the file lists
  int m_SortKey[2];                 // the column on which a list is sorted (1 = 1st, 2 = 2nd etc.; negative means reverse order)

  wxStaticText* m_CarTxt;           // "Car" text label
  wxStaticText* m_TrackTxt;         // "Track" text label
  wxChoice* m_CarChoice;            // dropdown box for the car filter
  wxChoice* m_TrackChoice;          // dropdown box for the track filter
  wxCheckBox* m_ReverseCheck;       // "Reverse" checkbox for the track filter

  wxButton* m_AllBtn;               // "All" button
  wxButton* m_OpenBtn;              // "Open" button
  wxButton* m_CancelBtn;            // "Cancel" button
  wxButton* m_FolderBtn;            // "Folder" button
  wxButton* m_DeleteBtn;            // "Delete" button
  wxButton* m_RenameBtn;            // "Rename" button
  wxButton* m_GetListBtn;           // "Get List" button

  wxBoxSizer* m_FilterSizer;        // sizer for the filters
  wxBoxSizer* m_MainButtonSizer;    // sizer for the OK/Cancel buttons
  wxBoxSizer* m_ButtonSizer[2];     // sizer for the buttons in the notebookpages
  wxBoxSizer* m_PageSizer[2];       // top-level sizer for notebookpages
  wxBoxSizer* m_TopSizer;           // top-level sizer

  wxMenu m_Context;                 // context menu

  cPubstatDlg* m_PubstatDialog;

  void ReadLocalFiles();
  void ReadLfswFiles();
  void DoSort(int index);

  wxString GetColumnText(int index, int col) const;
  void SetColumnText(int index, int col, const wxString& text);
  void SetSortKey(int index, int key);

  void EnableButtons();
  void DeleteSelection();
  void RenameSelection();
  void SelectAll();
  void DoEnter();
  void SetFilters(const wxString& car, const wxString& track, bool reverse = false);
  void ApplyFilters();

  void OnButton(wxCommandEvent& event);
  void OnCheckBox(wxCommandEvent& WXUNUSED(event)) { ApplyFilters(); }
  void OnColClick(wxListEvent& event);
  void OnItemActivate(wxListEvent& WXUNUSED(event)) { DoEnter(); }
  void OnItemRightClick(wxListEvent& event);
  void OnChangeSelection(wxListEvent& WXUNUSED(event)) { EnableButtons(); }
  void OnChangeFilter(wxCommandEvent& WXUNUSED(event)) { ApplyFilters(); }
  void OnKeyDown(wxListEvent& event);
  void OnPageChange(wxNotebookEvent& event);
  void OnMenuClick(wxCommandEvent& event);

  bool GetUrl(const wxString& strUrl, wxString* data);

  DECLARE_EVENT_TABLE()

public:
  cFileDlg(wxWindow* parent);
  virtual ~cFileDlg();

  int DoShowModal(const wxString& caption, bool add, cPubstatDlg* ident);
  void GetPaths(wxArrayString& paths) const;

  static wxString Flags2Steer(long flags);
  static wxString Flags2RhdLhd(long flags);
  static wxString LfswUrl2LapName(const wxString& url);
  static wxString LapData2LfswName(const wxString& user, const wxString& car, const wxString& track, long lapTime);
  static bool LfswName2LapData(const wxString& lapName, wxString& user, wxString& car, wxString& track, long* lapTime);
  static wxString LfswName2ReplayUrl(const wxString& lapName);

  virtual void TranslateTexts();

  virtual void LoadConfig(wxRegConfig* config, const wxString& key);
  virtual void SaveConfig(wxRegConfig* config, const wxString& key);
};

//-----------------------------------------------------------------------------

class cFileDlgItemData
{
public:
  int type;             // 0 = local, 1 = LFSW
  wxString filename;    // full filename
  wxString name;        // display name of the file
  wxString car;         // car code
  wxString track;       // track code
  int laptime;          // laptime (in ms)
  wxString filedate;    // file date&time (yyyy-mm-dd)
  wxString lfsversion;  // LFS version that generated the RAF file
  wxString player;      // LFS player name (for local files) or LFSW username (= WEB username)
  int chartpos;         // position in the hotlap chart (1 = WR)
  long flags;           // player flags (LHD, mouse steer, etc.)
  long sprnumber;       // identifier for downloading the SPR
  float sampling;       // sampling frequency
};

#endif
