#ifndef _CFILE_H_
#define _CFILE_H_

#include "global.h"
#include <wx/ffile.h>

//-----------------------------------------------------------------------------
// Base class to read from binary files

class cFile
{
private:
  wxFFile* m_File;         // the file from which to read
  wxString m_FileName;     // its pathname

public:
  cFile();
  virtual ~cFile();

  inline const wxString& GetFileName() const { return m_FileName; }

  bool Open(wxString fileName);
  void Close() { m_File->Close(); }
  inline bool IsOpened() { return m_File->IsOpened(); }
  inline bool Eof() { return m_File->Eof(); }

  inline void Skip(int bytes) { if (bytes > 0) m_File->Seek(bytes, wxFromCurrent); }
  inline void GoTo(int bytes) { m_File->Seek(bytes, wxFromStart); }

  void ReadString(wxString& dest, int count);
  void ReadByte(wxInt8& dest);
  void ReadWord(wxInt16& dest);
  void ReadInt(wxInt32& dest);
  void ReadFloat(float& dest);
};

//-----------------------------------------------------------------------------

#endif
