#include "cfile.h"

//-----------------------------------------------------------------------------

cFile::cFile()
{
  m_File = new wxFFile();
}

//-----------------------------------------------------------------------------

cFile::~cFile()
{
  if (m_File->IsOpened()) m_File->Close();
  delete m_File;
}

//-----------------------------------------------------------------------------
// Open a file

bool cFile::Open(wxString fileName)
{
  if (!m_File->Open(fileName, "rb")) return false;
  m_FileName = fileName;
  return true;
}

//----------------------------------------------------------------------------
// Read values from the file
// - dest = variable to store result in
// - count = max string length

void cFile::ReadString(wxString& dest, int count)
{
  wxASSERT(count > 0);
  char* buf = (char*)malloc(count + 1);
  m_File->Read(buf, (sizeof(char) * count));
  buf[count] = 0;
  dest = buf;
  free(buf);
}

void cFile::ReadByte(wxInt8& dest)
{
  m_File->Read(&dest, 1);
}

void cFile::ReadWord(wxInt16& dest)
{
  m_File->Read(&dest, 2);
}

void cFile::ReadInt(wxInt32& dest)
{
  m_File->Read(&dest, 4);
}

void cFile::ReadFloat(float& dest)
{
  wxInt32 i;
  ReadInt(i);
  dest = *((float*)&i);
}
