#ifndef _CCURVE_H_H_
#define _CCURVE_H_H_

#include "global.h"
#include "ccurve.h"
#include "ccarstate.h"
#include "clap.h"
#include <wx/dc.h>

class cGraph;

//-----------------------------------------------------------------------------
// A curve in a histogram

class cCurveH
: public cCurve
{
private:
  int m_Logtype;        // type of log-data to be shown
  int m_Wheel;          // index of the wheel for which the data must be shown

  wxArrayInt m_Bin;     // bin values (= number of samples whose value are in that bin)
  int m_BinCount;       // the number of bins
  float m_BinStart;     // start value of the first bin
  float m_BinEnd;       // end value of the last bin

  float m_SampleSum;    // sum of the samples counted
  int m_SampleCount;    // total number of samples counted
  float m_Average;      // average of the samples

  int m_PlotBin;        // index of the bin that is being plotted
  int m_PlotPoint;      // point of the bin that is given next (0 = topleft corner, 1 = bottomright)

public:
  cCurveH(cLap* lap);
  virtual ~cCurveH();

  virtual void Rewind(float start, float end, size_t maxPoints);
  virtual bool GetNextPoint(float& x, float& y);
  virtual void Plot(wxDC& dc, cGraph& graph, float start, float end);

  virtual void AdjustBbox();
  void SetBins(float start, float end, int bins);
  float GetAverage() const { return m_Average; }

  void SetLogtype(int log, int wheel);
};

#endif
